/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.wi.backend.server.dd;

import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jbpm.console.ng.wi.backend.server.dd.DDConfigUpdater;
import org.jbpm.console.ng.wi.backend.server.dd.DDConfigUpdaterHelper;
import org.jbpm.console.ng.wi.backend.server.dd.DDEditorServiceImpl;
import org.jbpm.console.ng.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.console.ng.wi.dd.model.ItemObjectModel;
import org.jbpm.console.ng.wi.dd.service.DDEditorService;
import org.jbpm.designer.notification.DesignerWorkitemInstalledEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceAddedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class DDConfigUpdaterTest {
    private static final String JPA_MARSHALLING_STRATEGY = "org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy";
    @Mock
    private IOService ioService;
    @Mock
    private KieProjectService projectService;
    @Mock
    private DDEditorServiceImpl ddEditorService;
    @Mock
    private DDConfigUpdaterHelper configUpdaterHelper;
    private DeploymentDescriptorModel model;
    private DDConfigUpdater ddConfigUpdater;

    @Before
    public void setup() {
        this.model = new DeploymentDescriptorModel();
        this.model.setOverview(new Overview());
        this.ddConfigUpdater = new DDConfigUpdater((DDEditorService)this.ddEditorService, this.projectService, this.ioService, this.configUpdaterHelper);
        org.uberfire.backend.vfs.Path rootPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)rootPath.toURI()).thenReturn((Object)"default://project");
        KieProject project = (KieProject)Mockito.mock(KieProject.class);
        Mockito.when((Object)project.getRootPath()).thenReturn((Object)rootPath);
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.configUpdaterHelper.isPersistenceFile((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)true);
        Mockito.when((Object)this.configUpdaterHelper.buildJPAMarshallingStrategyValue((KieProject)Matchers.any(KieProject.class))).thenReturn((Object)JPA_MARSHALLING_STRATEGY);
        Mockito.when((Object)this.projectService.resolveProject((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)project);
        Mockito.when((Object)this.ddEditorService.load((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)this.model);
    }

    @Test
    public void testProcessResourceAdd() {
        this.ddConfigUpdater.processResourceAdd(new ResourceAddedEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "test resource", (SessionInfo)Mockito.mock(SessionInfo.class)));
        Assert.assertNotNull((Object)this.model.getMarshallingStrategies());
        Assert.assertEquals((long)1L, (long)this.model.getMarshallingStrategies().size());
        ItemObjectModel objectModel = (ItemObjectModel)this.model.getMarshallingStrategies().get(0);
        Assert.assertNotNull((Object)objectModel);
        Assert.assertEquals((Object)JPA_MARSHALLING_STRATEGY, (Object)objectModel.getValue());
        Assert.assertEquals((Object)"mvel", (Object)objectModel.getResolver());
    }

    @Test
    public void testProcessWorkitemInstall() {
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "mvel", "new com.myhandlers.MyHandler()", "MyWorkItem", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)1L, (long)this.model.getWorkItemHandlers().size());
        ItemObjectModel objectModel = (ItemObjectModel)this.model.getWorkItemHandlers().get(0);
        Assert.assertNotNull((Object)objectModel);
        Assert.assertEquals((Object)"MyWorkItem", (Object)objectModel.getName());
        Assert.assertEquals((Object)"mvel", (Object)objectModel.getResolver());
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)objectModel.getValue());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "mvel", "new com.myhandlers.MyHandler2()", "MyWorkItem", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)1L, (long)this.model.getWorkItemHandlers().size());
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)((ItemObjectModel)this.model.getWorkItemHandlers().get(0)).getValue());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "reflection", "com.myhandlers.MyHandler", "MyWorkItem2", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)2L, (long)this.model.getWorkItemHandlers().size());
        ItemObjectModel objectModel2 = (ItemObjectModel)this.model.getWorkItemHandlers().get(1);
        Assert.assertNotNull((Object)objectModel2);
        Assert.assertEquals((Object)"MyWorkItem2", (Object)objectModel2.getName());
        Assert.assertEquals((Object)"reflection", (Object)objectModel2.getResolver());
        Assert.assertEquals((Object)"com.myhandlers.MyHandler", (Object)objectModel2.getValue());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "mvel", "new com.myhandlers.MyHandler3()", "", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)2L, (long)this.model.getWorkItemHandlers().size());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "mvel", "", "MyWorkItem3", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)2L, (long)this.model.getWorkItemHandlers().size());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "mvel", "", "", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)2L, (long)this.model.getWorkItemHandlers().size());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "reflection", "mvel: new com.myhandlers.MyHandler4()", "MyWorkItem4", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)3L, (long)this.model.getWorkItemHandlers().size());
        ItemObjectModel objectModel3 = (ItemObjectModel)this.model.getWorkItemHandlers().get(2);
        Assert.assertNotNull((Object)objectModel3);
        Assert.assertEquals((Object)"MyWorkItem4", (Object)objectModel3.getName());
        Assert.assertEquals((Object)"mvel", (Object)objectModel3.getResolver());
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler4()", (Object)objectModel3.getValue());
    }

    @Test
    public void testIsValidWorkitem() {
        Assert.assertFalse((boolean)this.ddConfigUpdater.isValidWorkitem(null));
        Assert.assertFalse((boolean)this.ddConfigUpdater.isValidWorkitem(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "", "", "", "")));
        Assert.assertFalse((boolean)this.ddConfigUpdater.isValidWorkitem(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "mvel", "", "", "")));
        Assert.assertFalse((boolean)this.ddConfigUpdater.isValidWorkitem(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "mvel", "new com.myhandlers.MyHandler()", "", "")));
        Assert.assertFalse((boolean)this.ddConfigUpdater.isValidWorkitem(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "mvel", "", "MyHandler", "")));
        Assert.assertTrue((boolean)this.ddConfigUpdater.isValidWorkitem(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "mvel", "new com.myhandlers.MyHandler()", "MyHandler", "")));
        Assert.assertTrue((boolean)this.ddConfigUpdater.isValidWorkitem(new DesignerWorkitemInstalledEvent((org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class), "", "mvel: new com.myhandlers.MyHandler()", "MyHandler", "")));
    }

    @Test
    public void testParseWorkitemValue() {
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("  new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("new com.myhandlers.MyHandler()   "));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("mvel: new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("reflection: new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("MVEL: new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("REFLECTION: new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("  MveL:     new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("   ReFlEcTIoN:new com.myhandlers.MyHandler()   "));
    }

    @Test
    public void testGetWorkitemResolver() {
        Assert.assertEquals((Object)"mvel", (Object)this.ddConfigUpdater.getWorkitemResolver("new com.myhandlers.MyHandler()", "mvel"));
        Assert.assertEquals((Object)"mvel", (Object)this.ddConfigUpdater.getWorkitemResolver("mvel:new com.myhandlers.MyHandler()", "reflection"));
        Assert.assertEquals((Object)"reflection", (Object)this.ddConfigUpdater.getWorkitemResolver("reflection:new com.myhandlers.MyHandler()", "mvel"));
        Assert.assertEquals((Object)"reflection", (Object)this.ddConfigUpdater.getWorkitemResolver("reflection:new com.myhandlers.MyHandler()", ""));
        Assert.assertEquals((Object)"reflection", (Object)this.ddConfigUpdater.getWorkitemResolver("new com.myhandlers.MyHandler()", ""));
        Assert.assertEquals((Object)"reflection", (Object)this.ddConfigUpdater.getWorkitemResolver("new com.myhandlers.MyHandler()", null));
    }
}

