/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.wi.backend.server.dd;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jbpm.console.ng.wi.backend.server.dd.DeploymentDescriptorImpl;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.xml.sax.SAXException;

public class DeploymentDescriptorIO {
    private static JAXBContext context = null;
    private static Schema schema = null;

    public static DeploymentDescriptor fromXml(InputStream inputStream) {
        try {
            Unmarshaller unmarshaller = DeploymentDescriptorIO.getContext().createUnmarshaller();
            unmarshaller.setSchema(schema);
            DeploymentDescriptor descriptor = (DeploymentDescriptor)unmarshaller.unmarshal(inputStream);
            return descriptor;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read deployment descriptor from xml", e);
        }
    }

    public static String toXml(DeploymentDescriptor descriptor) {
        try {
            Marshaller marshaller = DeploymentDescriptorIO.getContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.schemaLocation", (Object)"http://www.jboss.org/jbpm deployment-descriptor.xsd");
            marshaller.setSchema(schema);
            StringWriter stringWriter = new StringWriter();
            DeploymentDescriptor clone = ((DeploymentDescriptorImpl)descriptor).clearClone();
            marshaller.marshal((Object)clone, (Writer)stringWriter);
            String output = stringWriter.toString();
            return output;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate xml from deployment descriptor", e);
        }
    }

    public static JAXBContext getContext() throws JAXBException, SAXException {
        if (context == null) {
            Class[] jaxbClasses = new Class[]{DeploymentDescriptorImpl.class};
            context = JAXBContext.newInstance((Class[])jaxbClasses);
            URL schemaLocation = DeploymentDescriptorIO.class.getResource("/deployment-descriptor.xsd");
            schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaLocation);
        }
        return context;
    }
}

