/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.persistence.Persistence;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
public class GenerateDDLScriptsTests {
    private ScriptFile scriptFile;

    @Parameterized.Parameters(name="{0}")
    public static Collection<ScriptFile> dialect() {
        return Arrays.asList(new ScriptFile("org.hibernate.dialect.Oracle12cDialect", "oracle", true));
    }

    public GenerateDDLScriptsTests(ScriptFile scriptFile) {
        this.scriptFile = scriptFile;
    }

    @Test
    public void generateDDL() throws Exception {
        Path basePath = Paths.get("src", "main", "resources", "db", "ddl-scripts");
        Path createFilePath = this.scriptFile.buildCreateFile(basePath);
        Path dropFilePath = this.scriptFile.buildDropFile(basePath);
        Files.deleteIfExists(createFilePath);
        Files.deleteIfExists(dropFilePath);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.dialect", this.scriptFile.getDialect());
        properties.put("hibernate.id.new_generator_mappings", this.scriptFile.getNewGenerator());
        properties.put("javax.persistence.schema-generation.scripts.action", "drop-and-create");
        properties.put("javax.persistence.schema-generation.scripts.drop-target", dropFilePath.toString());
        properties.put("javax.persistence.schema-generation.scripts.create-target", createFilePath.toString());
        Persistence.generateSchema((String)"dbGenerateDDL", properties);
    }

    private static class ScriptFile {
        private String dialect;
        private String alias;
        private String prefix;
        private boolean newGenerator;

        public ScriptFile(String dialect, String alias, boolean newGenerator) {
            this(dialect, alias, alias, newGenerator);
        }

        public ScriptFile(String dialect, String alias, String prefix, boolean newGenerator) {
            this.dialect = dialect;
            this.alias = alias;
            this.prefix = prefix;
            this.newGenerator = newGenerator;
        }

        public Path buildCreateFile(Path basePath) {
            return basePath.resolve(this.alias).resolve(this.prefix + "-" + (this.newGenerator ? "new-" : "") + "jbpm-schema.sql");
        }

        public Path buildDropFile(Path basePath) {
            return basePath.resolve(this.alias).resolve(this.prefix + "-" + (this.newGenerator ? "new-" : "") + "jbpm-drop-schema.sql");
        }

        public String getNewGenerator() {
            return Boolean.toString(this.newGenerator);
        }

        public String getDialect() {
            return this.dialect;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dialect == null ? 0 : this.dialect.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScriptFile other = (ScriptFile)obj;
            return !(this.dialect == null ? other.dialect != null : !this.dialect.equals(other.dialect));
        }

        public String toString() {
            return this.alias + " New Generator mappings " + this.newGenerator;
        }
    }
}

