/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import org.jbpm.persistence.scripts.TestPersistenceContext;
import org.jbpm.test.persistence.scripts.DatabaseType;
import org.jbpm.test.persistence.scripts.PersistenceUnit;
import org.jbpm.test.persistence.scripts.ScriptsBase;
import org.jbpm.test.persistence.scripts.util.ScriptFilter;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class UpgradeScriptsTest
extends ScriptsBase {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeScriptsTest.class);
    private static final Long TEST_PROCESS_INSTANCE_ID = 1L;
    private static final Integer TEST_SESSION_ID = 1;
    private static final String DB_UPGRADE_SCRIPTS_RESOURCE_PATH = "/db/upgrade-scripts";
    private static final String DB_60_SCRIPTS_RESOURCE_PATH = "/ddl60";
    private String product;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> products() {
        return Arrays.asList("bpms", "jbpm");
    }

    public UpgradeScriptsTest(String product) {
        this.product = product;
    }

    @BeforeClass
    public static void hasToBeTested() {
        TestPersistenceContext ctx = new TestPersistenceContext();
        DatabaseType dbType = ctx.getDatabaseType();
        Assume.assumeTrue((dbType != DatabaseType.DB2 && dbType != DatabaseType.SYBASE ? 1 : 0) != 0);
    }

    private void createSchema60UsingDDLs() throws IOException, SQLException {
        UpgradeScriptsTest.executeScriptRunner((String)DB_60_SCRIPTS_RESOURCE_PATH, (ScriptFilter)ScriptFilter.init((boolean)false, (boolean)true));
    }

    private void dropFinalSchemaAfterUpgradingUsingDDLs() throws IOException, SQLException {
        UpgradeScriptsTest.executeScriptRunner((String)DB_60_SCRIPTS_RESOURCE_PATH, (ScriptFilter)ScriptFilter.init((boolean)false, (boolean)false));
        UpgradeScriptsTest.executeScriptRunner((String)"/db/ddl-scripts", (ScriptFilter)ScriptFilter.init((boolean)false, (boolean)false));
    }

    @Test
    public void testExecutingScripts() throws IOException, SQLException {
        logger.info("entering testExecutingScripts with type: {} ", (Object)this.product);
        try {
            this.createSchema60UsingDDLs();
            UpgradeScriptsTest.executeScriptRunner((String)DB_UPGRADE_SCRIPTS_RESOURCE_PATH, (ScriptFilter)ScriptFilter.init((boolean)false, (boolean)true), (String)this.product);
            this.startAndPersistSomeProcess();
        }
        finally {
            this.dropFinalSchemaAfterUpgradingUsingDDLs();
        }
    }

    private void startAndPersistSomeProcess() {
        TestPersistenceContext dbTestingContext = TestPersistenceContext.createAndInitContext(PersistenceUnit.DB_TESTING_VALIDATE);
        try {
            dbTestingContext.startAndPersistSomeProcess("minimalProcess");
            Assert.assertTrue((dbTestingContext.getStoredProcessesCount() == 1 ? 1 : 0) != 0);
        }
        finally {
            dbTestingContext.clean();
        }
    }

    @Test
    public void testPersistedProcess() throws IOException, ParseException, SQLException {
        logger.debug("entering testPersistedProcess with type: {}", (Object)this.product);
        try {
            this.createSchema60UsingDDLs();
            this.upgradeDbWithOldProcessAndTask(this.product);
            this.validateProcess();
        }
        finally {
            this.dropFinalSchemaAfterUpgradingUsingDDLs();
        }
    }

    private void upgradeDbWithOldProcessAndTask(String type) throws IOException, SQLException {
        TestPersistenceContext scriptRunnerContext = TestPersistenceContext.createAndInitContext(PersistenceUnit.SCRIPT_RUNNER);
        try {
            scriptRunnerContext.persistOldProcessAndSession(TEST_SESSION_ID, "minimalProcess", TEST_PROCESS_INSTANCE_ID);
            scriptRunnerContext.createSomeTask();
            scriptRunnerContext.executeScripts(new File(((Object)((Object)this)).getClass().getResource(DB_UPGRADE_SCRIPTS_RESOURCE_PATH).getFile()), ScriptFilter.init((boolean)false, (boolean)true), type);
        }
        finally {
            scriptRunnerContext.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateProcess() {
        TestPersistenceContext dbTestingContext = new TestPersistenceContext();
        dbTestingContext.init(PersistenceUnit.DB_TESTING_VALIDATE);
        try {
            Assert.assertTrue((dbTestingContext.getStoredProcessesCount() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((dbTestingContext.getStoredSessionsCount() == 1 ? 1 : 0) != 0);
            StatefulKnowledgeSession persistedSession = dbTestingContext.loadPersistedSession(TEST_SESSION_ID.longValue(), "minimalProcess");
            Assert.assertNotNull((Object)persistedSession);
            persistedSession.startProcess("minimalProcess");
            Assert.assertTrue((dbTestingContext.getStoredProcessesCount() == 2 ? 1 : 0) != 0);
            ProcessInstance processInstance = persistedSession.getProcessInstance(TEST_PROCESS_INSTANCE_ID.longValue());
            Assert.assertNotNull((Object)processInstance);
            persistedSession.signalEvent("test", null);
            processInstance = persistedSession.getProcessInstance(TEST_PROCESS_INSTANCE_ID.longValue());
            Assert.assertNull((Object)processInstance);
            Assert.assertTrue((dbTestingContext.getStoredProcessesCount() == 0 ? 1 : 0) != 0);
            persistedSession.dispose();
            persistedSession.destroy();
            Assert.assertTrue((dbTestingContext.getStoredSessionsCount() == 0 ? 1 : 0) != 0);
        }
        finally {
            dbTestingContext.clean();
        }
    }
}

