/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.persistence.Persistence;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
public class GenerateDDLScriptsTests {
    public static final boolean USE_BYTEA = false;
    private ScriptFile scriptFile;

    @Parameterized.Parameters(name="{0}")
    public static Collection<ScriptFile> dialect() {
        return Arrays.asList(new ScriptFile("org.hibernate.dialect.DB2Dialect", "db2", "db2", "", false), new ScriptFile("org.hibernate.dialect.DerbyDialect", "derby", "derby", "", false), new ScriptFile("org.hibernate.dialect.H2Dialect", "h2", "h2", "", false), new ScriptFile("org.hibernate.dialect.HSQLDialect", "hsqldb", "hsqldb", "", false), new ScriptFile("org.hibernate.dialect.MySQL5Dialect", "mysql5", "mysql5", "", false), new ScriptFile("org.hibernate.dialect.MySQLInnoDBDialect", "mysqlinnodb", "mysql", "innodb", false), new ScriptFile("org.hibernate.dialect.Oracle10gDialect", "oracle", "oracle", "", false), new ScriptFile("org.hibernate.dialect.Oracle10gDialect", "oracle", "oracle", "springboot", true), new ScriptFile("org.hibernate.dialect.PostgreSQLDialect", "postgresql", "postgresql", "springboot", true), new ScriptFile("org.hibernate.dialect.PostgreSQLDialect", "postgresql", "postgresql", "", false), new ScriptFile("org.hibernate.dialect.SQLServer2012Dialect", "sqlserver", "sqlserver", "", false), new ScriptFile("org.hibernate.dialect.SQLServer2012Dialect", "sqlserver", "sqlserver", "springboot", true), new ScriptFile("org.hibernate.dialect.SQLServer2008Dialect", "sqlserver2008", "sqlserver2008", "", false), new ScriptFile("org.hibernate.dialect.SybaseDialect", "sybase", "sybase", "", false));
    }

    public GenerateDDLScriptsTests(ScriptFile scriptFile) {
        this.scriptFile = scriptFile;
    }

    @Test
    public void generateDDL() throws Exception {
        Path basePath = Paths.get("src", "main", "resources", "db", "ddl-scripts");
        Path createFilePath = this.scriptFile.buildCreateFile(basePath);
        Path dropFilePath = this.scriptFile.buildDropFile(basePath);
        Files.deleteIfExists(createFilePath);
        Files.deleteIfExists(dropFilePath);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.dialect", this.scriptFile.getDialect());
        properties.put("hibernate.id.new_generator_mappings", this.scriptFile.getNewGenerator());
        properties.put("javax.persistence.schema-generation.scripts.action", "drop-and-create");
        properties.put("javax.persistence.schema-generation.scripts.drop-target", dropFilePath.toString());
        properties.put("javax.persistence.schema-generation.scripts.create-target", createFilePath.toString());
        Persistence.generateSchema((String)"dbGenerateDDL", properties);
    }

    static {
        System.setProperty("org.kie.persistence.postgresql.useBytea", Boolean.toString(false));
    }

    public static class ScriptFile {
        private String dialect;
        private String alias;
        private String prefix;
        private String subtype;
        private boolean newGenerator;

        public ScriptFile(String dialect, String alias, String prefix, String subtype, boolean newGenerator) {
            this.dialect = dialect;
            this.alias = alias;
            this.prefix = prefix;
            this.subtype = subtype;
            this.newGenerator = newGenerator;
        }

        public Path buildCreateFile(Path basePath) {
            return basePath.resolve(this.alias).resolve(this.prefix + "-" + (this.subtype.isEmpty() ? "" : this.subtype + "-") + "jbpm-schema.sql");
        }

        public Path buildDropFile(Path basePath) {
            return basePath.resolve(this.alias).resolve(this.prefix + "-" + (this.subtype.isEmpty() ? "" : this.subtype + "-") + "jbpm-drop-schema.sql");
        }

        public String getNewGenerator() {
            return Boolean.toString(this.newGenerator);
        }

        public String getDialect() {
            return this.dialect;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dialect == null ? 0 : this.dialect.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScriptFile other = (ScriptFile)obj;
            return !(this.dialect == null ? other.dialect != null : !this.dialect.equals(other.dialect));
        }

        public String toString() {
            return this.alias + "-" + this.subtype + " new Generator mappings " + this.newGenerator;
        }
    }
}

