/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import org.jbpm.persistence.scripts.TestPersistenceContext;
import org.jbpm.test.persistence.scripts.DatabaseType;
import org.jbpm.test.persistence.scripts.DistributionType;
import org.jbpm.test.persistence.scripts.PersistenceUnit;
import org.jbpm.test.persistence.scripts.ScriptsBase;
import org.jbpm.test.persistence.scripts.util.ScriptFilter;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class UpgradeScriptsTest
extends ScriptsBase {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeScriptsTest.class);
    private static final Long TEST_PROCESS_INSTANCE_ID = 1L;
    private static final Integer TEST_SESSION_ID = 1;
    private static final String DB_UPGRADE_SCRIPTS_RESOURCE_PATH = "/db/upgrade-scripts";
    private static final String DB_60_SCRIPTS_RESOURCE_PATH = "/ddl60";
    private DistributionType distributionType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> distributionTypes() {
        return Arrays.asList(DistributionType.COMMUNITY, DistributionType.PRODUCT);
    }

    public UpgradeScriptsTest(DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    @BeforeClass
    public static void hasToBeTested() {
        TestPersistenceContext ctx = new TestPersistenceContext();
        DatabaseType dbType = ctx.getDatabaseType();
        Assume.assumeTrue((dbType != DatabaseType.DB2 && dbType != DatabaseType.SYBASE ? 1 : 0) != 0);
    }

    @Before
    public void prepare() throws IOException {
        this.replaceNewGeneratorMappingsValue(ScriptFilter.init((boolean)false, (boolean)false));
    }

    private void createSchema60UsingDDLs() throws IOException, SQLException {
        UpgradeScriptsTest.executeScriptRunner((String)DB_60_SCRIPTS_RESOURCE_PATH, (ScriptFilter)ScriptFilter.init((boolean)false, (boolean)true));
    }

    private void dropFinalSchemaAfterUpgradingUsingDDLs() throws IOException, SQLException {
        UpgradeScriptsTest.executeScriptRunner((String)DB_60_SCRIPTS_RESOURCE_PATH, (ScriptFilter)ScriptFilter.init((boolean)false, (boolean)false));
        UpgradeScriptsTest.executeScriptRunner((String)"/db/ddl-scripts", (ScriptFilter)ScriptFilter.init((boolean)false, (boolean)false));
    }

    @Test
    public void testExecutingScripts() throws IOException, SQLException {
        logger.info("entering testExecutingScripts with type: {} ", (Object)this.distributionType);
        try {
            this.createSchema60UsingDDLs();
            UpgradeScriptsTest.executeScriptRunner((String)DB_UPGRADE_SCRIPTS_RESOURCE_PATH, (ScriptFilter)ScriptFilter.init((boolean)false, (boolean)true).setDistribution(this.distributionType));
            this.startAndPersistSomeProcess();
        }
        finally {
            this.dropFinalSchemaAfterUpgradingUsingDDLs();
        }
    }

    @Test
    public void testTaskAssigningScripts() throws IOException, SQLException {
        logger.info("entering testTaskAssigningScripts with type: {} ", (Object)this.distributionType);
        try {
            this.createSchema60UsingDDLs();
            ScriptFilter taskAssigningTable = ScriptFilter.filter((String[])new String[]{"task_assigning_tables_"}).exclude(new String[]{"drop"}).setOptions(new ScriptFilter.Option[]{ScriptFilter.Option.DISALLOW_EMPTY_RESULTS, ScriptFilter.Option.THROW_ON_SCRIPT_ERROR});
            UpgradeScriptsTest.executeScriptRunner((String)"/db/ddl-scripts", (ScriptFilter)taskAssigningTable);
            UpgradeScriptsTest.executeScriptRunner((String)DB_UPGRADE_SCRIPTS_RESOURCE_PATH, (ScriptFilter)ScriptFilter.init((boolean)false, (boolean)true).setDistribution(this.distributionType));
            ScriptFilter scriptFilter = ScriptFilter.filter((String[])new String[]{"task_assigning_tables.sql"}).setDistribution(this.distributionType).setOptions(new ScriptFilter.Option[]{ScriptFilter.Option.THROW_ON_SCRIPT_ERROR});
            UpgradeScriptsTest.executeScriptRunner((String)DB_UPGRADE_SCRIPTS_RESOURCE_PATH, (ScriptFilter)scriptFilter);
            this.startAndPersistSomeProcess();
        }
        catch (Throwable throwable) {
            this.dropFinalSchemaAfterUpgradingUsingDDLs();
            UpgradeScriptsTest.executeScriptRunner((String)"/db/ddl-scripts", (ScriptFilter)ScriptFilter.filter((String[])new String[]{"task_assigning_tables_drop_"}));
            throw throwable;
        }
        this.dropFinalSchemaAfterUpgradingUsingDDLs();
        UpgradeScriptsTest.executeScriptRunner((String)"/db/ddl-scripts", (ScriptFilter)ScriptFilter.filter((String[])new String[]{"task_assigning_tables_drop_"}));
    }

    private void startAndPersistSomeProcess() {
        TestPersistenceContext dbTestingContext = TestPersistenceContext.createAndInitContext(PersistenceUnit.DB_TESTING_VALIDATE);
        try {
            dbTestingContext.startAndPersistSomeProcess("minimalProcess");
            Assert.assertEquals((long)1L, (long)dbTestingContext.getStoredProcessesCount());
        }
        finally {
            dbTestingContext.clean();
        }
    }

    @Test
    public void testPersistedProcess() throws IOException, SQLException {
        logger.debug("entering testPersistedProcess with type: {}", (Object)this.distributionType);
        try {
            this.createSchema60UsingDDLs();
            this.upgradeDbWithOldProcessAndTask(this.distributionType);
            this.validateProcess();
        }
        finally {
            this.dropFinalSchemaAfterUpgradingUsingDDLs();
        }
    }

    private void upgradeDbWithOldProcessAndTask(DistributionType type) throws IOException, SQLException {
        TestPersistenceContext scriptRunnerContext = TestPersistenceContext.createAndInitContext(PersistenceUnit.SCRIPT_RUNNER);
        try {
            scriptRunnerContext.persistOldProcessAndSession(TEST_SESSION_ID, "minimalProcess", TEST_PROCESS_INSTANCE_ID);
            scriptRunnerContext.createSomeTask();
            scriptRunnerContext.executeScripts(new File(((Object)((Object)this)).getClass().getResource(DB_UPGRADE_SCRIPTS_RESOURCE_PATH).getFile()), ScriptFilter.init((boolean)false, (boolean)true).setDistribution(type));
        }
        finally {
            scriptRunnerContext.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateProcess() {
        TestPersistenceContext dbTestingContext = new TestPersistenceContext();
        dbTestingContext.init(PersistenceUnit.DB_TESTING_VALIDATE);
        try {
            Assert.assertEquals((long)1L, (long)dbTestingContext.getStoredProcessesCount());
            Assert.assertEquals((long)1L, (long)dbTestingContext.getStoredSessionsCount());
            StatefulKnowledgeSession persistedSession = dbTestingContext.loadPersistedSession(TEST_SESSION_ID.longValue(), "minimalProcess");
            Assert.assertNotNull((Object)persistedSession);
            persistedSession.startProcess("minimalProcess");
            Assert.assertEquals((long)2L, (long)dbTestingContext.getStoredProcessesCount());
            ProcessInstance processInstance = persistedSession.getProcessInstance(TEST_PROCESS_INSTANCE_ID.longValue());
            Assert.assertNotNull((Object)processInstance);
            persistedSession.signalEvent("test", null);
            processInstance = persistedSession.getProcessInstance(TEST_PROCESS_INSTANCE_ID.longValue());
            Assert.assertNull((Object)processInstance);
            Assert.assertEquals((long)0L, (long)dbTestingContext.getStoredProcessesCount());
            persistedSession.dispose();
            persistedSession.destroy();
            Assert.assertEquals((long)0L, (long)dbTestingContext.getStoredSessionsCount());
        }
        finally {
            dbTestingContext.clean();
        }
    }
}

