/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.types;

import java.math.BigInteger;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jbpm.persistence.types.TestEntity;
import org.jbpm.test.persistence.scripts.DatabaseType;
import org.jbpm.test.persistence.scripts.PersistenceUnit;
import org.jbpm.test.persistence.scripts.TestPersistenceContextBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class PosgresqlTypesTest {
    public static final int STRLENGTH = 1000000;
    private TestPersistenceContextBase persistenceContext;

    @Before
    public void setup() {
        System.setProperty("org.kie.persistence.postgresql.useBytea", "true");
        System.setProperty("org.kie.persistence.postgresql.useText", "true");
        this.persistenceContext = new TestPersistenceContextBase();
        this.persistenceContext.init(PersistenceUnit.TEST_TYPES);
        Assume.assumeTrue((boolean)this.persistenceContext.getDatabaseType().equals((Object)DatabaseType.POSTGRESQL));
    }

    @After
    public void tear() {
        System.clearProperty("org.kie.persistence.postgresql.useBytea");
        System.clearProperty("org.kie.persistence.postgresql.useText");
        this.persistenceContext.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateEntityByteArray() {
        this.persistenceContext.getTransactionManager().begin();
        int pgCount = this.getPgLargeObjectCounter();
        TestEntity testEntity = new TestEntity();
        testEntity.setProcessInstanceByteArray(this.getLongString().getBytes());
        try (EntityManager em = this.persistenceContext.getEntityManagerFactory().createEntityManager();){
            em.persist((Object)testEntity);
        }
        this.persistenceContext.getTransactionManager().commit(true);
        this.persistenceContext.getTransactionManager().begin();
        Assert.assertEquals((long)pgCount, (long)this.getPgLargeObjectCounter());
        this.persistenceContext.getTransactionManager().commit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateEntityErrorInfo() {
        this.persistenceContext.getTransactionManager().begin();
        int pgCount = this.getPgLargeObjectCounter();
        TestEntity testEntity = new TestEntity();
        testEntity.setErrorInfo(this.getLongString());
        try (EntityManager em = this.persistenceContext.getEntityManagerFactory().createEntityManager();){
            em.persist((Object)testEntity);
        }
        this.persistenceContext.getTransactionManager().commit(true);
        this.persistenceContext.getTransactionManager().begin();
        Assert.assertEquals((long)pgCount, (long)this.getPgLargeObjectCounter());
        this.persistenceContext.getTransactionManager().commit(true);
    }

    private String getLongString() {
        StringBuilder dot = new StringBuilder();
        for (int i = 0; i < 1000000; ++i) {
            dot.append(".");
        }
        return dot.toString();
    }

    private int getPgLargeObjectCounter() {
        try (EntityManager em = this.persistenceContext.getEntityManagerFactory().createEntityManager();){
            int n = this.getPgLargeObjectCounter(em);
            return n;
        }
    }

    private int getPgLargeObjectCounter(EntityManager session) {
        Query query = session.createNativeQuery("select count(*) from pg_largeobject_metadata");
        return ((BigInteger)query.getSingleResult()).intValue();
    }
}

