/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.jbpm.persistence.scripts.oldentities.ProcessInstanceInfo;
import org.jbpm.persistence.scripts.oldentities.SessionInfo;
import org.jbpm.persistence.scripts.oldentities.TaskImpl;
import org.jbpm.test.persistence.scripts.PersistenceUnit;
import org.jbpm.test.persistence.scripts.TestPersistenceContextBase;
import org.jbpm.test.persistence.scripts.util.TestsUtil;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.TaskData;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalI18NText;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTaskData;

public final class TestPersistenceContext
extends TestPersistenceContextBase {
    public void createSomeTask() {
        this.testIsInitialized();
        TaskImpl task = new TaskImpl();
        InternalI18NText name = (InternalI18NText)TaskModelProvider.getFactory().newI18NText();
        name.setText("Some Task");
        ArrayList<I18NText> names = new ArrayList<I18NText>();
        names.add((I18NText)name);
        task.setNames(names);
        InternalTaskData taskData = (InternalTaskData)TaskModelProvider.getFactory().newTaskData();
        taskData.setWorkItemId(12L);
        taskData.setProcessInstanceId(1L);
        taskData.setProcessId("someprocess");
        taskData.setDeploymentId("org.jbpm.test:someprocess:1.0");
        taskData.setProcessSessionId(1L);
        task.setTaskData((TaskData)taskData);
        InternalPeopleAssignments peopleAssignments = (InternalPeopleAssignments)TaskModelProvider.getFactory().newPeopleAssignments();
        peopleAssignments.setPotentialOwners(new ArrayList());
        peopleAssignments.setBusinessAdministrators(new ArrayList());
        peopleAssignments.setExcludedOwners(new ArrayList());
        peopleAssignments.setRecipients(new ArrayList());
        peopleAssignments.setTaskStakeholders(new ArrayList());
        InternalOrganizationalEntity jdoe = (InternalOrganizationalEntity)TaskModelProvider.getFactory().newUser();
        jdoe.setId("jdoe");
        peopleAssignments.getPotentialOwners().add(jdoe);
        peopleAssignments.getBusinessAdministrators().add(jdoe);
        task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
        boolean txOwner = this.transactionManager.begin();
        try {
            EntityManager em = this.entityManagerFactory.createEntityManager();
            em.persist((Object)jdoe);
            em.persist((Object)task);
            this.transactionManager.commit(txOwner);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.transactionManager.rollback(txOwner);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static TestPersistenceContext createAndInitContext(PersistenceUnit persistenceUnit) {
        TestPersistenceContext testPersistenceContext = new TestPersistenceContext();
        testPersistenceContext.init(persistenceUnit);
        return testPersistenceContext;
    }

    public void persistOldProcessAndSession(Integer sessionId, String processId, Long processInstanceId) {
        this.testIsInitialized();
        boolean txOwner = this.transactionManager.begin();
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            entityManager.merge((Object)this.getOldProcessInstanceInfo(processId, processInstanceId));
            entityManager.merge((Object)this.getOldSessionInfo(sessionId));
            entityManager.flush();
            entityManager.close();
            this.transactionManager.commit(txOwner);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.transactionManager.rollback(txOwner);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private ProcessInstanceInfo getOldProcessInstanceInfo(String processId, Long processInstanceId) throws ParseException {
        DateFormat dateFormat = this.getDateFormat();
        ProcessInstanceInfo result = new ProcessInstanceInfo();
        result.setProcessInstanceId(processInstanceId);
        result.setEventTypes(this.getOldProcessEventTypes());
        result.setLastModificationDate(dateFormat.parse("2015-08-25 13:43:25.760"));
        result.setLastReadDate(dateFormat.parse("2015-08-25 13:43:25.210"));
        result.setProcessId(processId);
        result.setStartDate(dateFormat.parse("2015-08-25 13:43:25.190"));
        result.setState(1);
        result.setVersion(2);
        result.setProcessInstanceByteArray(TestsUtil.hexStringToByteArray((String)"ACED00057769000852756C65466C6F770A0608061004180052550A0852756C65466C6F7710011A0E6D696E696D616C50726F63657373200128023A0A0801100222020805280160006A0E5F6A62706D2D756E697175652D3072120A0E5F6A62706D2D756E697175652D311001800101"));
        return result;
    }

    private SessionInfo getOldSessionInfo(Integer sessionId) throws ParseException {
        DateFormat dateFormat = this.getDateFormat();
        SessionInfo result = new SessionInfo();
        result.setId(sessionId);
        result.setLastModificationDate(dateFormat.parse("2015-08-25 13:43:25.248"));
        result.setStartDate(dateFormat.parse("2015-08-25 13:43:24.858"));
        result.setVersion(2);
        result.setData(TestsUtil.hexStringToByteArray((String)"ACED0005777C0A060806100418005272080010001A6818002000320608011000180042231A190A044D41494E10001801200028FFFFFFFFFFFFFFFFFF01400022060A044D41494E52350A0744454641554C54222A0A266F72672E64726F6F6C732E636F72652E726574656F6F2E496E697469616C46616374496D706C100022026800"));
        return result;
    }

    private Set<String> getOldProcessEventTypes() {
        HashSet<String> resultSet = new HashSet<String>(1);
        resultSet.add("test");
        return resultSet;
    }

    private DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }
}

