/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.scripts;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.persistence.scripts.TestPersistenceContext;
import org.jbpm.test.persistence.scripts.DatabaseType;
import org.jbpm.test.persistence.scripts.PersistenceUnit;
import org.jbpm.test.persistence.scripts.ScriptsBase;
import org.jbpm.test.persistence.scripts.util.ScriptFilter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DDLScriptsTest
extends ScriptsBase {
    private ScriptFilter createScript;
    private ScriptFilter dropScript;
    private Map<String, Object> oldEnvironment;

    @Parameterized.Parameters
    public static Collection<ScriptFilter[]> data() {
        ScriptFilter[] standard = new ScriptFilter[]{ScriptFilter.init((boolean)false, (boolean)true), ScriptFilter.init((boolean)false, (boolean)false)};
        ScriptFilter[] sbPg = new ScriptFilter[]{ScriptFilter.filter((String[])new String[]{"postgresql-springboot-jbpm-schema.sql", "quartz_tables_postgres.sql"}).setSupportedDatabase(new DatabaseType[]{DatabaseType.POSTGRESQL}).setOptions(new ScriptFilter.Option[]{ScriptFilter.Option.DISALLOW_EMPTY_RESULTS, ScriptFilter.Option.THROW_ON_SCRIPT_ERROR, ScriptFilter.Option.NEW_GENERATOR_MAPPINGS_TRUE}), ScriptFilter.filter((String[])new String[]{"postgresql-springboot-jbpm-drop-schema.sql", "quartz_tables_drop_postgres.sql"})};
        ScriptFilter[] pqlBytea = new ScriptFilter[]{ScriptFilter.filter((String[])new String[]{"postgresql-bytea-jbpm-schema.sql", "quartz_tables_postgres.sql"}).setSupportedDatabase(new DatabaseType[]{DatabaseType.POSTGRESQL}).setOptions(new ScriptFilter.Option[]{ScriptFilter.Option.DISALLOW_EMPTY_RESULTS, ScriptFilter.Option.THROW_ON_SCRIPT_ERROR}).env("org.kie.persistence.postgresql.useBytea", (Object)"true"), ScriptFilter.filter((String[])new String[]{"postgresql-bytea-jbpm-drop-schema.sql", "quartz_tables_drop_postgres.sql"})};
        ScriptFilter[] pqlSpringBootBytea = new ScriptFilter[]{ScriptFilter.filter((String[])new String[]{"postgresql-springboot-bytea-jbpm-schema.sql", "quartz_tables_postgres.sql"}).setSupportedDatabase(new DatabaseType[]{DatabaseType.POSTGRESQL}).setOptions(new ScriptFilter.Option[]{ScriptFilter.Option.DISALLOW_EMPTY_RESULTS, ScriptFilter.Option.THROW_ON_SCRIPT_ERROR, ScriptFilter.Option.NEW_GENERATOR_MAPPINGS_TRUE}).env("org.kie.persistence.postgresql.useBytea", (Object)"true"), ScriptFilter.filter((String[])new String[]{"postgresql-springboot-bytea-jbpm-drop-schema.sql", "quartz_tables_drop_postgres.sql"})};
        ScriptFilter[] sbOracle = new ScriptFilter[]{ScriptFilter.filter((String[])new String[]{"oracle-springboot-jbpm-schema.sql", "quartz_tables_oracle.sql"}).setSupportedDatabase(new DatabaseType[]{DatabaseType.ORACLE}).setOptions(new ScriptFilter.Option[]{ScriptFilter.Option.DISALLOW_EMPTY_RESULTS, ScriptFilter.Option.THROW_ON_SCRIPT_ERROR, ScriptFilter.Option.NEW_GENERATOR_MAPPINGS_TRUE}), ScriptFilter.filter((String[])new String[]{"oracle-springboot-jbpm-drop-schema.sql", "quartz_tables_drop_oracle.sql"})};
        ScriptFilter[] mySqlCluster = new ScriptFilter[]{ScriptFilter.filter((String[])new String[]{"mysql-innodb-cluster-jbpm-schema.sql", "quartz_tables_mysql_innodb.sql"}).setSupportedDatabase(new DatabaseType[]{DatabaseType.MYSQLINNODB}).setOptions(new ScriptFilter.Option[]{ScriptFilter.Option.DISALLOW_EMPTY_RESULTS, ScriptFilter.Option.THROW_ON_SCRIPT_ERROR}), ScriptFilter.filter((String[])new String[]{"mysql-innodb-jbpm-drop-schema.sql", "quartz_tables_drop_mysql_innodb.sql"})};
        ScriptFilter[] taskAssigningTables = new ScriptFilter[]{ScriptFilter.filter((ScriptFilter.Filter)ScriptFilter.Filter.OUT, (String[])new String[]{"drop", "bytea", "springboot", "cluster"}).setOptions(new ScriptFilter.Option[]{ScriptFilter.Option.DISALLOW_EMPTY_RESULTS, ScriptFilter.Option.THROW_ON_SCRIPT_ERROR}), ScriptFilter.filter((String[])new String[]{"jbpm-drop-schema.sql", "quartz_tables_drop_", "task_assigning_tables_drop_"})};
        return Arrays.asList(standard, sbPg, pqlBytea, pqlSpringBootBytea, sbOracle, mySqlCluster, taskAssigningTables);
    }

    public DDLScriptsTest(ScriptFilter createScript, ScriptFilter dropScript) {
        this.createScript = createScript;
        this.dropScript = dropScript;
    }

    @Before
    public void prepare() throws IOException {
        this.replaceNewGeneratorMappingsValue(this.createScript);
        this.oldEnvironment = new HashMap<String, Object>();
        Map newEnvironment = this.createScript.getEnvironment();
        for (Map.Entry entry : newEnvironment.entrySet()) {
            this.oldEnvironment.put((String)entry.getKey(), System.getProperty((String)entry.getKey()));
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        TestPersistenceContext scriptRunnerContext = TestPersistenceContext.createAndInitContext(PersistenceUnit.SCRIPT_RUNNER);
        DatabaseType dbType = scriptRunnerContext.getDatabaseType();
        Assume.assumeTrue((String)("Scripts test not supported this database " + dbType + ": " + this.createScript.getSupportedDatabase()), (boolean)this.createScript.isSupportedDatabase(dbType));
    }

    @After
    public void tear() {
        for (Map.Entry<String, Object> entry : this.oldEnvironment.entrySet()) {
            if (entry.getValue() != null) {
                System.setProperty(entry.getKey(), (String)entry.getValue());
                continue;
            }
            System.clearProperty(entry.getKey());
        }
    }

    @Test
    public void createAndDropSchemaUsingDDLs() throws Exception {
        DDLScriptsTest.executeScriptRunner((String)"/db/ddl-scripts", (ScriptFilter)this.createScript);
        this.validateAndPersistProcess();
        this.validateQuartz();
        DDLScriptsTest.executeScriptRunner((String)"/db/ddl-scripts", (ScriptFilter)this.dropScript);
    }

    protected void validateAndPersistProcess() {
        TestPersistenceContext dbTestingContext = TestPersistenceContext.createAndInitContext(PersistenceUnit.DB_TESTING_VALIDATE);
        try {
            dbTestingContext.startAndPersistSomeProcess("minimalProcess");
            Assert.assertEquals((long)1L, (long)dbTestingContext.getStoredProcessesCount());
        }
        finally {
            dbTestingContext.clean();
        }
    }

    protected void validateQuartz() {
        TestPersistenceContext dbquartzContext = TestPersistenceContext.createAndInitContext(PersistenceUnit.DB_QUARTZ_VALIDATE);
        dbquartzContext.clean();
    }
}

