/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository.vfs;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class RepositoryDescriptorProvider {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryService repositoryService;
    private Map<String, RepositoryDescriptor> knownRepositories = new ConcurrentHashMap<String, RepositoryDescriptor>();

    @PostConstruct
    public void init() {
        Collection active = this.repositoryService.getRepositories();
        if (active != null) {
            for (Repository repo : active) {
                this.buildAndRegister(repo);
            }
        }
    }

    public RepositoryDescriptor getRepositoryDescriptor(String repositoryAlias) {
        if (this.knownRepositories.containsKey(repositoryAlias)) {
            return this.knownRepositories.get(repositoryAlias);
        }
        if (this.knownRepositories.size() == 1) {
            return this.knownRepositories.values().iterator().next();
        }
        Repository repository = this.repositoryService.getRepository(repositoryAlias);
        if (repository != null) {
            return this.buildAndRegister(repository);
        }
        throw new IllegalStateException("Repository with alias " + repositoryAlias + " not found");
    }

    private RepositoryDescriptor buildAndRegister(Repository repository) {
        URI root = URI.create(repository.getUri());
        FileSystem fs = this.ioService.getFileSystem(root);
        Path rootPath = fs.provider().getPath(root);
        RepositoryDescriptor descriptor = new RepositoryDescriptor(root, fs, rootPath);
        this.knownRepositories.put(repository.getAlias(), descriptor);
        return descriptor;
    }
}

