/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.jbpm.designer.server.Repository;
import org.jbpm.designer.server.StencilSetExtensionGenerator;
import org.supercsv.io.CsvMapReader;
import org.supercsv.prefs.CsvPreference;

public class StencilSetExtensionGeneratorServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected String baseUrl;
    protected Repository repository;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.baseUrl = Repository.getBaseUrl(request);
        this.repository = new Repository(this.baseUrl);
        String modelNamePrefix = "Generated Model using ";
        String stencilSetExtensionNamePrefix = "Generated Stencil Set Extension";
        String baseStencilSetPath = "/stencilsets/bpmn1.1/bpmn1.1.json";
        String baseStencilSet = "http://b3mn.org/stencilset/bpmn1.1#";
        String baseStencil = "Task";
        ArrayList<String> stencilSetExtensionUrls = new ArrayList<String>();
        String[] columnPropertyMapping = null;
        String[] csvHeader = null;
        ArrayList<Map<String, String>> stencilPropertyMatrix = new ArrayList<Map<String, String>>();
        String modelDescription = "The initial version of this model has been created by the Stencilset Extension Generator.";
        String additionalERDFContentForGeneratedModel = "";
        String[] modelTags = null;
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            ServletFileUpload upload = new ServletFileUpload();
            try {
                FileItemIterator iterator = upload.getItemIterator(request);
                while (iterator.hasNext()) {
                    Map row;
                    FileItemStream item = iterator.next();
                    String name = item.getFieldName();
                    InputStream stream = item.openStream();
                    if (item.isFormField()) {
                        String value = Streams.asString((InputStream)stream);
                        if (name.equals("modelNamePrefix")) {
                            modelNamePrefix = value;
                            continue;
                        }
                        if (name.equals("stencilSetExtensionNamePrefix")) {
                            stencilSetExtensionNamePrefix = value;
                            continue;
                        }
                        if (name.equals("baseStencilSetPath")) {
                            baseStencilSetPath = value;
                            continue;
                        }
                        if (name.equals("baseStencilSet")) {
                            baseStencilSet = value;
                            continue;
                        }
                        if (name.equals("stencilSetExtension")) {
                            stencilSetExtensionUrls.add(value);
                            continue;
                        }
                        if (name.equals("baseStencil")) {
                            baseStencil = value;
                            continue;
                        }
                        if (name.equals("columnPropertyMapping")) {
                            columnPropertyMapping = value.split(",");
                            continue;
                        }
                        if (name.equals("modelDescription")) {
                            modelDescription = value;
                            continue;
                        }
                        if (name.equals("modelTags")) {
                            modelTags = value.split(",");
                            continue;
                        }
                        if (!name.equals("additionalERDFContentForGeneratedModel")) continue;
                        additionalERDFContentForGeneratedModel = value;
                        continue;
                    }
                    if (!name.equals("csvFile")) continue;
                    CsvMapReader csvFileReader = new CsvMapReader((Reader)new InputStreamReader(stream, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
                    csvHeader = csvFileReader.getCSVHeader(true);
                    if (columnPropertyMapping != null || columnPropertyMapping.length > 0) {
                        csvHeader = columnPropertyMapping;
                    }
                    while ((row = csvFileReader.read(csvHeader)) != null) {
                        stencilPropertyMatrix.add(row);
                    }
                }
                Date creationDate = new Date(System.currentTimeMillis());
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss.SSS");
                String stencilSetExtensionName = stencilSetExtensionNamePrefix + " " + dateFormat.format(creationDate);
                stencilSetExtensionUrls.add(StencilSetExtensionGenerator.generateStencilSetExtension(stencilSetExtensionName, stencilPropertyMatrix, columnPropertyMapping, baseStencilSet, baseStencil));
                String modelName = modelNamePrefix + stencilSetExtensionName;
                String model = this.repository.generateERDF(UUID.randomUUID().toString(), additionalERDFContentForGeneratedModel, baseStencilSetPath, baseStencilSet, stencilSetExtensionUrls, modelName, modelDescription);
                String modelUrl = this.baseUrl + this.repository.saveNewModel(model, modelName, modelDescription, baseStencilSet, baseStencilSetPath);
                modelUrl = modelUrl.substring(modelUrl.lastIndexOf("http://"));
                if (modelTags != null) {
                    for (String tagName : modelTags) {
                        this.repository.addTag(modelUrl, tagName.trim());
                    }
                }
                response.setHeader("Location", modelUrl);
                response.setStatus(301);
            }
            catch (FileUploadException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void println(String output) {
        try {
            this.response.getWriter().println(output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

