/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.plugin.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.web.plugin.IDiagramPlugin;
import org.jbpm.designer.web.plugin.IDiagramPluginFactory;
import org.jbpm.designer.web.plugin.IDiagramPluginService;
import org.jbpm.designer.web.plugin.impl.LocalPluginImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginServiceImpl
implements IDiagramPluginService {
    private static PluginServiceImpl _instance = null;
    private static Map<String, IDiagramPlugin> LOCAL = null;
    private static Logger _logger = LoggerFactory.getLogger(PluginServiceImpl.class);
    private Map<String, IDiagramPlugin> _registry = new HashMap<String, IDiagramPlugin>();
    private Set<IDiagramPluginFactory> _factories = new HashSet<IDiagramPluginFactory>();

    public static IDiagramPluginService getInstance(ServletContext context) {
        if (_instance == null) {
            _instance = new PluginServiceImpl(context);
        }
        return _instance;
    }

    public static Map<String, IDiagramPlugin> getLocalPluginsRegistry(ServletContext context) {
        if (LOCAL == null) {
            LOCAL = PluginServiceImpl.initializeLocalPlugins(context);
        }
        return LOCAL;
    }

    private static Map<String, IDiagramPlugin> initializeLocalPlugins(ServletContext context) {
        HashMap<String, IDiagramPlugin> local = new HashMap<String, IDiagramPlugin>();
        FileInputStream fileStream = null;
        try {
            try {
                fileStream = new FileInputStream(context.getRealPath("/") + ConfigurationProvider.getInstance().getDesignerContext() + "js" + "/" + "Plugins" + "/" + "plugins.xml");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(fileStream, "UTF-8");
            while (reader.hasNext()) {
                if (reader.next() != 1 || !"plugin".equals(reader.getLocalName())) continue;
                String source = null;
                String name = null;
                boolean core = false;
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    if ("source".equals(reader.getAttributeLocalName(i))) {
                        source = reader.getAttributeValue(i);
                        continue;
                    }
                    if ("name".equals(reader.getAttributeLocalName(i))) {
                        name = reader.getAttributeValue(i);
                        continue;
                    }
                    if (!"core".equals(reader.getAttributeLocalName(i))) continue;
                    core = Boolean.parseBoolean(reader.getAttributeValue(i));
                }
                HashMap<String, Object> props = new HashMap<String, Object>();
                while (reader.hasNext()) {
                    int ev = reader.next();
                    if (ev == 1) {
                        if (!"property".equals(reader.getLocalName())) continue;
                        String key = null;
                        String value = null;
                        for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            if ("name".equals(reader.getAttributeLocalName(i))) {
                                key = reader.getAttributeValue(i);
                                continue;
                            }
                            if (!"value".equals(reader.getAttributeLocalName(i))) continue;
                            value = reader.getAttributeValue(i);
                        }
                        if (!(key != null & value != null)) continue;
                        props.put(key, value);
                        continue;
                    }
                    if (ev != 2 || !"plugin".equals(reader.getLocalName())) continue;
                    break;
                }
                local.put(name, new LocalPluginImpl(name, source, context, core, props));
            }
        }
        catch (XMLStreamException e) {
            _logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {}
            }
        }
        return local;
    }

    private PluginServiceImpl(ServletContext context) {
        this._registry.putAll(PluginServiceImpl.getLocalPluginsRegistry(context));
        if (this.getClass().getClassLoader() instanceof BundleReference) {
            final BundleContext bundleContext = ((BundleReference)this.getClass().getClassLoader()).getBundle().getBundleContext();
            ServiceReference[] sRefs = null;
            try {
                sRefs = bundleContext.getServiceReferences(IDiagramPluginFactory.class.getName(), null);
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
            if (sRefs != null) {
                for (ServiceReference sRef : sRefs) {
                    IDiagramPluginFactory service = (IDiagramPluginFactory)bundleContext.getService(sRef);
                    this._factories.add(service);
                }
            }
            ServiceTrackerCustomizer cust = new ServiceTrackerCustomizer(){

                public void removedService(ServiceReference reference, Object service) {
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }

                public Object addingService(ServiceReference reference) {
                    IDiagramPluginFactory service = (IDiagramPluginFactory)bundleContext.getService(reference);
                    PluginServiceImpl.this._factories.add(service);
                    return service;
                }
            };
            ServiceTracker tracker = new ServiceTracker(bundleContext, IDiagramPluginFactory.class.getName(), cust);
            tracker.open();
            bundleContext.registerService(IDiagramPluginService.class.getName(), (Object)this, new Hashtable());
        }
    }

    private Map<String, IDiagramPlugin> assemblePlugins(HttpServletRequest request) {
        HashMap<String, IDiagramPlugin> plugins = new HashMap<String, IDiagramPlugin>(this._registry);
        for (IDiagramPluginFactory factory : this._factories) {
            for (IDiagramPlugin p : factory.getPlugins(request)) {
                plugins.put(p.getName(), p);
            }
        }
        return plugins;
    }

    @Override
    public Collection<IDiagramPlugin> getRegisteredPlugins(HttpServletRequest request) {
        return this.assemblePlugins(request).values();
    }

    @Override
    public IDiagramPlugin findPlugin(HttpServletRequest request, String name) {
        return this.assemblePlugins(request).get(name);
    }
}

