/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.stencilset.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.web.stencilset.IDiagramStencilSet;
import org.jbpm.designer.web.stencilset.IDiagramStencilSetFactory;
import org.jbpm.designer.web.stencilset.IDiagramStencilSetService;
import org.jbpm.designer.web.stencilset.impl.LocalStencilSetImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StencilSetServiceImpl
implements IDiagramStencilSetService {
    private static Logger _logger = LoggerFactory.getLogger(StencilSetServiceImpl.class);
    public static final String designer_path = ConfigurationProvider.getInstance().getDesignerContext();
    private Map<String, IDiagramStencilSet> _registry = new HashMap<String, IDiagramStencilSet>();
    private Set<IDiagramStencilSetFactory> _factories = new HashSet<IDiagramStencilSetFactory>();

    public StencilSetServiceImpl(ServletContext context) {
        this.initializeLocalStencilSets(context);
        if (this.getClass().getClassLoader() instanceof BundleReference) {
            final BundleContext bundleContext = ((BundleReference)this.getClass().getClassLoader()).getBundle().getBundleContext();
            ServiceReference[] sRefs = null;
            try {
                sRefs = bundleContext.getServiceReferences(IDiagramStencilSet.class.getName(), null);
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
            if (sRefs != null) {
                for (ServiceReference sRef : sRefs) {
                    IDiagramStencilSetFactory service = (IDiagramStencilSetFactory)bundleContext.getService(sRef);
                    this._factories.add(service);
                }
            }
            ServiceTrackerCustomizer cust = new ServiceTrackerCustomizer(){

                public void removedService(ServiceReference reference, Object service) {
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }

                public Object addingService(ServiceReference reference) {
                    IDiagramStencilSetFactory service = (IDiagramStencilSetFactory)bundleContext.getService(reference);
                    StencilSetServiceImpl.this._factories.add(service);
                    return service;
                }
            };
            ServiceTracker tracker = new ServiceTracker(bundleContext, IDiagramStencilSetFactory.class.getName(), cust);
            tracker.open();
            bundleContext.registerService(IDiagramStencilSetService.class.getName(), (Object)this, new Hashtable());
        }
    }

    private void initializeLocalStencilSets(ServletContext context) {
        File ssDir = new File(context.getRealPath(designer_path + "stencilsets"));
        for (File dir : ssDir.listFiles()) {
            if (!dir.isDirectory()) continue;
            this._registry.put(dir.getName(), new LocalStencilSetImpl(dir.getName(), dir.getAbsolutePath()));
        }
    }

    private Map<String, IDiagramStencilSet> assembleStencilSets(HttpServletRequest request) {
        HashMap<String, IDiagramStencilSet> stencilsets = new HashMap<String, IDiagramStencilSet>(this._registry);
        for (IDiagramStencilSetFactory factory : this._factories) {
            for (IDiagramStencilSet p : factory.getStencilSets(request)) {
                stencilsets.put(p.getName(), p);
            }
        }
        return stencilsets;
    }

    @Override
    public Collection<IDiagramStencilSet> getRegisteredStencilSets(HttpServletRequest request) {
        return this.assembleStencilSets(request).values();
    }

    @Override
    public IDiagramStencilSet findStencilSet(HttpServletRequest request, String name) {
        return this.assembleStencilSets(request).get(name);
    }
}

