/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.validation;

import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jbpm.designer.type.Bpmn2TypeDefinition;
import org.kie.workbench.common.services.backend.validation.FileNameValidator;
import org.kie.workbench.common.services.backend.validation.ValidationUtils;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class BPMN2FileNameValidator
implements FileNameValidator {
    private static List<String> EXTRA_INVALID_FILENAME_CHARS = Arrays.asList("+");
    @Inject
    private Bpmn2TypeDefinition resourceType;

    public int getPriority() {
        return 1;
    }

    public boolean accept(String fileName) {
        return fileName.endsWith("." + this.resourceType.getSuffix());
    }

    public boolean accept(Path path) {
        return this.resourceType.accept(path);
    }

    public boolean isValid(String value) {
        if (!this.processAssetFileNameValid(value)) {
            return false;
        }
        return ValidationUtils.isFileName((String)value);
    }

    private boolean processAssetFileNameValid(String str) {
        for (String item : EXTRA_INVALID_FILENAME_CHARS) {
            if (!str.contains(item)) continue;
            return false;
        }
        return true;
    }
}

