/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.fop.svg.PDFTranscoder;

public class AlternativesRenderer
extends HttpServlet {
    private static final long serialVersionUID = 8526319871562210085L;
    private String baseFilename;
    private String inFile;
    private String outFile;

    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        String data = req.getParameter("data");
        try {
            data = new String(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        String tmpPath = this.getServletContext().getRealPath("/") + File.separator + "tmp" + File.separator;
        File tmpFolder = new File(tmpPath);
        if (!tmpFolder.exists()) {
            tmpFolder.mkdirs();
        }
        this.baseFilename = String.valueOf(System.currentTimeMillis());
        this.inFile = tmpPath + this.baseFilename + ".svg";
        this.outFile = tmpPath + this.baseFilename + ".pdf";
        try {
            String contextPath = req.getContextPath();
            BufferedWriter out = new BufferedWriter(new FileWriter(this.inFile));
            out.write(data);
            out.close();
            this.makePDF();
            res.getOutputStream().print(contextPath + "/tmp/" + this.baseFilename + ".pdf");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makePDF() throws TranscoderException, IOException {
        PDFTranscoder transcoder = new PDFTranscoder();
        FileInputStream in = new FileInputStream(this.inFile);
        try {
            TranscoderInput input = new TranscoderInput((InputStream)in);
            OutputStream out = new FileOutputStream(this.outFile);
            out = new BufferedOutputStream(out);
            try {
                TranscoderOutput output = new TranscoderOutput(out);
                transcoder.transcode(input, output);
            }
            finally {
                out.close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }
}

