/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.service;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.jbpm.designer.service.BPMN2DataServices;
import org.jbpm.designer.service.DesignerAssetService;
import org.jbpm.designer.service.DesignerContent;
import org.jbpm.designer.util.Utils;
import org.json.JSONArray;
import org.kie.workbench.common.services.backend.service.KieService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class DefaultDesignerAssetService
extends KieService<DesignerContent>
implements DesignerAssetService {
    private static Logger logger = LoggerFactory.getLogger(DefaultDesignerAssetService.class);
    @Inject
    private Repository repository;
    @Inject
    private Instance<BPMN2DataServices> bpmn2DataServices;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryDescriptor descriptor;
    private static final int socketBufferSize = 8192;
    private static final Logger _logger = LoggerFactory.getLogger(DefaultDesignerAssetService.class);
    public static final String PROCESS_STUB = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<bpmn2:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.omg.org/bpmn20\" xmlns:bpmn2=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:bpsim=\"http://www.bpsim.org/schemas/1.0\" xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:drools=\"http://www.jboss.org/drools\" \nid=\"Definition\" xsi:schemaLocation=\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd http://www.jboss.org/drools drools.xsd http://www.bpsim.org/schemas/1.0 bpsim.xsd\" expressionLanguage=\"http://www.mvel.org/2.0\" targetNamespace=\"http://www.omg.org/bpmn20\" typeLanguage=\"http://www.java.com/javaTypes\"> \n   <bpmn2:process id=\"${processid}\" drools:packageName=\"org.jbpm\" drools:version=\"1.0\" name=\"\" isExecutable=\"true\"> \n      <bpmn2:startEvent id=\"processStartEvent\" drools:bgcolor=\"#9acd32\" drools:selectable=\"true\" name=\"\"/> \n   </bpmn2:process> \n   <bpmndi:BPMNDiagram> \n      <bpmndi:BPMNPlane bpmnElement=\"${processid}\"> \n         <bpmndi:BPMNShape bpmnElement=\"processStartEvent\"> \n            <dc:Bounds height=\"30.0\" width=\"30.0\" x=\"120.0\" y=\"165.0\"/> \n         </bpmndi:BPMNShape> \n      </bpmndi:BPMNPlane> \n   </bpmndi:BPMNDiagram> \n</bpmn2:definitions>";

    public DesignerContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (DesignerContent)super.loadContent(path);
    }

    public Map<String, String> getEditorParameters(org.uberfire.backend.vfs.Path path, String editorID, String hostInfo, PlaceRequest place) {
        boolean readOnly;
        List<Object> activeNodesList = new ArrayList();
        String activeNodesParam = place.getParameter("activeNodes", null);
        boolean bl = readOnly = place.getParameter("readOnly", null) != null;
        if (!readOnly) {
            try {
                this.ioService.getFileSystem(URI.create(path.toURI()));
            }
            catch (Exception e) {
                logger.error("Unable to create file system: " + e.getMessage());
                throw new FileSystemNotFoundException(e.getMessage());
            }
        }
        String processId = place.getParameter("processId", "");
        String deploymentId = place.getParameter("deploymentId", "");
        String encodedProcessSource = "";
        try {
            encodedProcessSource = ((BPMN2DataServices)this.bpmn2DataServices.iterator().next()).getProcessSources(deploymentId, processId);
        }
        catch (Exception e) {
            encodedProcessSource = place.getParameter("encodedProcessSource", "");
        }
        if (activeNodesParam != null) {
            activeNodesList = Arrays.asList(activeNodesParam.split(","));
        }
        List<Object> completedNodesList = new ArrayList();
        String completedNodesParam = place.getParameter("completedNodes", null);
        if (completedNodesParam != null) {
            completedNodesList = Arrays.asList(completedNodesParam.split(","));
        }
        JSONArray activeNodesArray = new JSONArray(activeNodesList);
        JSONArray completedNodesArray = new JSONArray(completedNodesList);
        HashMap<String, String> editorParamsMap = new HashMap<String, String>();
        editorParamsMap.put("hostinfo", hostInfo);
        try {
            editorParamsMap.put("uuid", Base64.encodeBase64URLSafeString((byte[])UriUtils.decode(path.toURI()).getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        editorParamsMap.put("profile", "jbpm");
        editorParamsMap.put("pp", "");
        editorParamsMap.put("editorid", editorID);
        editorParamsMap.put("readonly", String.valueOf(readOnly));
        editorParamsMap.put("activenodes", activeNodesArray.toString());
        editorParamsMap.put("completednodes", completedNodesArray.toString());
        editorParamsMap.put("processsource", encodedProcessSource);
        if (!readOnly) {
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
        }
        return editorParamsMap;
    }

    public String getEditorID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public org.uberfire.backend.vfs.Path createProcess(org.uberfire.backend.vfs.Path context, String fileName) {
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName));
        String location = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().toString();
        String name = path.getFileName();
        String processId = this.buildProcessId(location, name);
        String processContent = PROCESS_STUB.replaceAll("\\$\\{processid\\}", processId.replaceAll("\\s", ""));
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(name);
        builder.location(location).content(processContent).uniqueId(path.toURI());
        Asset processAsset = builder.getAsset();
        this.repository.createAsset(processAsset);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEditorResponse(String urlpath, String encProcessSrc) {
        UrlEncodedFormEntity formEntity;
        URL url;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            url = new URL(urlpath);
        }
        catch (MalformedURLException murle) {
            logger.error("Incorrect URL: " + murle.getMessage(), (Throwable)murle);
            return null;
        }
        try {
            Socket socket = new Socket(url.getHost(), url.getPort());
            DefaultBHttpClientConnection conn = new DefaultBHttpClientConnection(8192);
            conn.bind(socket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>(2);
        formParams.add(new BasicNameValuePair("j_username", "admin"));
        formParams.add(new BasicNameValuePair("j_password", "admin"));
        try {
            formEntity = new UrlEncodedFormEntity(formParams);
        }
        catch (UnsupportedEncodingException uee) {
            logger.error("Could not encode authentication parameters into request body", (Throwable)uee);
            return null;
        }
        HttpPost authMethod = new HttpPost(urlpath);
        authMethod.setEntity((HttpEntity)formEntity);
        try {
            httpClient.execute((HttpUriRequest)authMethod);
        }
        catch (IOException ioe) {
            logger.error("Could not initialize form-based authentication", (Throwable)ioe);
            String string = null;
            return string;
        }
        finally {
            authMethod.releaseConnection();
        }
        HttpPost theMethod = new HttpPost(urlpath);
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("processsource", (Object)encProcessSrc);
        theMethod.setParams((HttpParams)params);
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)theMethod);
            HttpEntity respEntity = response.getEntity();
            String responseBody = null;
            if (respEntity != null) {
                responseBody = EntityUtils.toString((HttpEntity)respEntity);
            }
            String string = responseBody;
            return string;
        }
        catch (Exception e) {
            logger.error("Could not do POST method and retrieve content: " + e.getMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            theMethod.releaseConnection();
        }
    }

    private String buildProcessId(String location, String name) {
        if (location.startsWith("/")) {
            location = location.replaceFirst("/", "");
        }
        if ((location = location.replaceAll("/", ".")).length() > 0) {
            String[] locationParts = location.split("\\.");
            location = locationParts[0];
        }
        name = name.substring(0, name.lastIndexOf("."));
        name = Utils.toBPMNIdentifier(name);
        return location + "." + name;
    }

    public void updateMetadata(org.uberfire.backend.vfs.Path resource, Metadata metadata) {
        this.ioService.setAttributes(Paths.convert((org.uberfire.backend.vfs.Path)resource), this.metadataService.setUpAttributes(resource, metadata));
    }

    protected DesignerContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        return new DesignerContent(overview);
    }
}

