/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.editorhandler;

import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestServletConfig;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.server.EditorHandler;
import org.jbpm.designer.web.preprocessing.IDiagramPreprocessingService;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class EditorHandlerBaseTest
extends RepositoryBaseTest {
    @Mock
    IDiagramProfileService profileService;
    @Mock
    IDiagramPreprocessingService preprocessingService;
    private Repository repository;
    @Spy
    @InjectMocks
    private EditorHandler editorHandler = new EditorHandler();
    @Captor
    private ArgumentCaptor<String> stringCaptor;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.profileService.findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString())).thenReturn((Object)this.profile);
        this.repository = new VFSRepository(this.producer.getIoService());
        ((VFSRepository)this.repository).setDescriptor(this.descriptor);
        this.profile.setRepository(this.repository);
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
        System.clearProperty("designer.showpdfdoc");
        System.clearProperty("org.jbpm.service.repository");
        System.clearProperty("org.jbpm.service.servicetasknames");
    }

    @Test
    public void testGetInstanceViewMode() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceviewmode", "false");
        Assert.assertEquals((String)this.editorHandler.getInstanceViewMode((HttpServletRequest)new TestHttpServletRequest(params)), (String)"false");
        params.put("instanceviewmode", "true");
        Assert.assertEquals((String)this.editorHandler.getInstanceViewMode((HttpServletRequest)new TestHttpServletRequest(params)), (String)"true");
        params.remove("instanceviewmode");
        Assert.assertEquals((String)this.editorHandler.getInstanceViewMode((HttpServletRequest)new TestHttpServletRequest(params)), (String)"false");
    }

    @Test
    public void testDoShowPDFDoc() throws Exception {
        TestServletConfig config = new TestServletConfig(new TestServletContext(this.repository));
        Assert.assertFalse((boolean)this.editorHandler.doShowPDFDoc((ServletConfig)config));
        config.getServletContext().setInitParameter("designer.showpdfdoc", "false");
        Assert.assertFalse((boolean)this.editorHandler.doShowPDFDoc((ServletConfig)config));
        config.getServletContext().setInitParameter("designer.showpdfdoc", "true");
        Assert.assertTrue((boolean)this.editorHandler.doShowPDFDoc((ServletConfig)config));
        config.getServletContext().setInitParameter("designer.showpdfdoc", "true");
        System.setProperty("designer.showpdfdoc", "false");
        Assert.assertFalse((boolean)this.editorHandler.doShowPDFDoc((ServletConfig)config));
        config.getServletContext().setInitParameter("designer.showpdfdoc", "false");
        System.setProperty("designer.showpdfdoc", "true");
        Assert.assertTrue((boolean)this.editorHandler.doShowPDFDoc((ServletConfig)config));
    }

    @Test
    public void testDoGetFindProfile() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        try {
            this.editorHandler.doGet(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.times((int)1))).findProfile(request, "jbpm");
    }

    @Test
    public void testDoGetProfileAlreadySet() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.editorHandler.setProfile((IDiagramProfile)this.profile);
        try {
            this.editorHandler.doGet(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.never())).findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString());
    }

    @Test
    public void testServiceRepoAndTaskSystem() throws Exception {
        System.setProperty("org.jbpm.service.repository", "service repo");
        System.setProperty("org.jbpm.service.servicetasknames", "taskA,taskB");
        TestServletConfig config = new TestServletConfig(new TestServletContext(this.repository));
        this.verifyServiceRepoAndTasks(config, true);
    }

    @Test
    public void testServiceRepoAndTaskServlet() throws Exception {
        TestServletContext context = new TestServletContext(this.repository);
        context.setInitParameter("org.jbpm.service.repository", "service repo");
        context.setInitParameter("org.jbpm.service.servicetasknames", "taskA,taskB");
        TestServletConfig config = new TestServletConfig(context);
        this.verifyServiceRepoAndTasks(config, true);
    }

    @Test
    public void testServiceRepoAndTaskEmpty() throws Exception {
        TestServletConfig config = new TestServletConfig(new TestServletContext(this.repository));
        this.verifyServiceRepoAndTasks(config, false);
    }

    private void verifyServiceRepoAndTasks(ServletConfig config, boolean present) throws Exception {
        PrintWriter writer = (PrintWriter)Mockito.mock(PrintWriter.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)writer);
        this.editorHandler.init(config);
        this.editorHandler.doGet((HttpServletRequest)Mockito.mock(HttpServletRequest.class), response);
        ((PrintWriter)Mockito.verify((Object)writer)).write((String)this.stringCaptor.capture());
        if (present) {
            Assert.assertTrue((boolean)((String)this.stringCaptor.getValue()).contains("ORYX.SERVICE_REPO = \"service repo\";"));
            Assert.assertTrue((boolean)((String)this.stringCaptor.getValue()).contains("ORYX.SERVICE_REPO_TASKS"));
            Assert.assertTrue((boolean)((String)this.stringCaptor.getValue()).contains("\"name\" : \"taskA\""));
            Assert.assertTrue((boolean)((String)this.stringCaptor.getValue()).contains("\"name\" : \"taskB\""));
        } else {
            Assert.assertTrue((boolean)((String)this.stringCaptor.getValue()).contains("ORYX.SERVICE_REPO = \"\";"));
            Assert.assertFalse((boolean)((String)this.stringCaptor.getValue()).contains("\"name\" : \"taskA\""));
            Assert.assertFalse((boolean)((String)this.stringCaptor.getValue()).contains("\"name\" : \"taskB\""));
        }
    }
}

