/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.service;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jbpm.designer.repository.Directory;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.server.service.DefaultDesignerAssetService;
import org.jbpm.designer.util.Base64Backport;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultDesignerAssetServiceTest
extends RepositoryBaseTest {
    @Mock
    private IOService ioService;
    @Mock
    MetadataServerSideService metadataService;
    @InjectMocks
    DefaultDesignerAssetService service;

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testUpdateMetaData() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        Directory testProjectDir = repository.createDirectory("/mytestproject");
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)this.producer.getIoService().get(URI.create(this.decodeUniqueId(testProjectDir.getUniqueId()))));
        Metadata metadata = new Metadata();
        HashMap map = new HashMap();
        Mockito.when((Object)this.metadataService.setUpAttributes(path, metadata)).thenReturn(map);
        this.service.updateMetadata(path, metadata);
        ((IOService)Mockito.verify((Object)this.ioService)).setAttributes((Path)Matchers.any(Path.class), (Map)Matchers.eq(map));
    }

    private String decodeUniqueId(String uniqueId) {
        if (Base64Backport.isBase64((String)uniqueId)) {
            byte[] decoded = Base64.decodeBase64((String)uniqueId);
            try {
                String uri = new String(decoded, "UTF-8");
                return UriUtils.encode((String)uri);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return UriUtils.encode((String)uniqueId);
    }
}

