/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MultiDownloader
extends HttpServlet {
    private static final long serialVersionUID = 544537395679618334L;

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.performDownload(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.performDownload(req, res);
    }

    private void prepareHeaders(HttpServletResponse res, String mimetype, String name) {
        res.setHeader("Pragma", "public");
        res.setHeader("Expires", "0");
        res.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        res.addHeader("Cache-Control", "private");
        res.setHeader("Content-Transfer-Encoding", "binary");
        res.setHeader("Content-Type", mimetype);
        res.setHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
    }

    private void zip(String[] filenames, String[] contents, OutputStream whereTo) throws IOException {
        assert (filenames.length == contents.length);
        ZipOutputStream out = new ZipOutputStream(whereTo);
        for (int i = 0; i < filenames.length; ++i) {
            out.putNextEntry(new ZipEntry(filenames[i]));
            out.write(contents[i].getBytes());
            out.closeEntry();
        }
        out.close();
    }

    private void performDownload(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getParameter("download_0") != null) {
            String content;
            int i = 0;
            Vector<String> contents = new Vector<String>();
            Vector<String> names = new Vector<String>();
            while ((content = req.getParameter("download_" + i)) != null) {
                String name = req.getParameter("file_" + i++);
                contents.add(content);
                names.add(name);
            }
            String[] contentsArray = new String[contents.size()];
            String[] namesArray = new String[names.size()];
            this.prepareHeaders(res, "application/zip", "result.zip");
            this.zip(names.toArray(namesArray), contents.toArray(contentsArray), (OutputStream)res.getOutputStream());
        } else if (req.getParameter("download") != null) {
            String name = req.getParameter("file");
            String content = req.getParameter("download");
            this.prepareHeaders(res, "", name);
            res.getWriter().write(content);
        } else {
            res.getWriter().println("There is nothing to be downloaded.");
        }
    }
}

