/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jbpm.designer.server.RdfJsonTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Repository {
    private static final Logger logger = LoggerFactory.getLogger(Repository.class);
    public static final String NEW_MODEL_SVG_STRING = "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:oryx=\"http://oryx-editor.org\" id=\"oryx_98F1C176-75F8-4C0A-899E-0F5E352A5F58\" width=\"10\" height=\"10\" xlink=\"http://www.w3.org/1999/xlink\" svg=\"http://www.w3.org/2000/svg\"><defs/><g stroke=\"none\" font-family=\"Verdana\" font-size=\"12\"><g class=\"stencils\" transform=\"translate(0)\"><g class=\"me\"/><g class=\"children\"/><g class=\"edge\"/></g></g></svg>";
    public static final String DEFAULT_STENCILSET = "/stencilsets/bpmn1.1/bpmn1.1.json";
    public static final String DEFAULT_TYPE = "http://b3mn.org/stencilset/bpmn1.1#";
    public static final String DEFAULT_MODEL_TYPE = "http://b3mn.org/stencilset/bpmn1.1#BPMNDiagram";
    public static final String DEFAULT_MODEL_NAME = "Generated Model";
    public static final String DEFAULT_MODEL_DESCRIPTION = "The initial version of this model has been generated automatically.";
    protected String baseUrl;

    public Repository(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Repository(HttpServletRequest request) {
        this.baseUrl = Repository.getBaseUrl(request);
    }

    public static String getBaseUrl(HttpServletRequest req) {
        String baseUrl = req.getRequestURL().toString();
        baseUrl = baseUrl.substring(baseUrl.lastIndexOf("http://"));
        return baseUrl.substring(0, baseUrl.length() - req.getRequestURI().length() + 1);
    }

    public static String getOryxUrl(HttpServletRequest req) {
        return Repository.getBaseUrl(req) + "oryx/";
    }

    public String getOryxUrl() {
        return this.baseUrl + "oryx/";
    }

    public static String getOryxPath() {
        return System.getProperty("catalina.home") + "/webapps/oryx/";
    }

    public String getModel(String path) {
        return this.getModel(path, "self");
    }

    public String getModel(String path, String representationType) {
        String result = "";
        String urlString = this.baseUrl + path + "/" + representationType;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(urlString);
            HttpResponse response = client.execute((HttpUriRequest)get);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != -1) {
                HttpEntity entity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)entity);
            } else {
                logger.error("GET to '{}' failed with status {}", (Object)urlString, (Object)statusCode);
            }
        }
        catch (Exception e) {
            logger.error("GET to '{}' failed: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String generateERDF(String modelId, String modelData) {
        return this.generateERDF(modelId, modelData, DEFAULT_STENCILSET, DEFAULT_MODEL_TYPE, null, DEFAULT_MODEL_NAME, DEFAULT_MODEL_DESCRIPTION);
    }

    public String generateERDF(String modelId, String modelData, String stencilset) {
        return this.generateERDF(modelId, modelData, stencilset, DEFAULT_MODEL_TYPE, null, DEFAULT_MODEL_NAME, DEFAULT_MODEL_DESCRIPTION);
    }

    public String generateERDF(String modelId, String modelData, String stencilset, String modelType) {
        return this.generateERDF(modelId, modelData, stencilset, modelType, null, DEFAULT_MODEL_NAME, DEFAULT_MODEL_DESCRIPTION);
    }

    public String generateERDF(String modelId, String modelData, String stencilset, String modelType, List<String> stencilSetExtensionUrls) {
        return this.generateERDF(modelId, modelData, stencilset, modelType, stencilSetExtensionUrls, DEFAULT_MODEL_NAME, DEFAULT_MODEL_DESCRIPTION);
    }

    public String generateERDF(String modelId, String modelData, String stencilset, String modelType, List<String> stencilSetExtensionUrls, String modelName) {
        return this.generateERDF(modelId, modelData, stencilset, modelType, stencilSetExtensionUrls, modelName, DEFAULT_MODEL_DESCRIPTION);
    }

    public String generateERDF(String modelId, String modelData, String stencilset, String modelType, List<String> stencilSetExtensionUrls, String modelName, String modelDescription) {
        String stencilsetLocation = this.baseUrl + "oryx" + stencilset;
        String erdf = "<div id=\"oryx-canvas123\" class=\"-oryx-canvas\"><span class=\"oryx-type\">" + modelType + "</span><span class=\"oryx-id\">" + modelId + "</span><span class=\"oryx-name\">" + modelName + "</span><span class=\"oryx-version\"></span><span class=\"oryx-author\"></span><span class=\"oryx-language\">English</span><span class=\"oryx-expressionlanguage\"></span><span class=\"oryx-querylanguage\"></span><span class=\"oryx-creationdate\"></span><span class=\"oryx-modificationdate\"></span><span class=\"oryx-pools\"></span><span class=\"oryx-documentation\">" + modelDescription + "</span><span class=\"oryx-mode\">writable</span><span class=\"oryx-mode\">fullscreen</span><a rel=\"oryx-stencilset\" href=\"" + stencilsetLocation + "\"/>";
        if (stencilSetExtensionUrls != null) {
            ListIterator<String> iterator = stencilSetExtensionUrls.listIterator();
            while (iterator.hasNext()) {
                erdf = erdf + "<span class=\"oryx-ssextension\">" + iterator.next() + "</span>";
            }
        }
        erdf = erdf + modelData + "</div>";
        return erdf;
    }

    public String saveNewModel(String newModel, String name) {
        return this.saveNewModel(newModel, name, "", DEFAULT_TYPE, DEFAULT_STENCILSET, NEW_MODEL_SVG_STRING);
    }

    public String saveNewModel(String newModel, String name, String summary) {
        return this.saveNewModel(newModel, name, summary, DEFAULT_TYPE, DEFAULT_STENCILSET, NEW_MODEL_SVG_STRING);
    }

    public String saveNewModel(String newModel, String name, String summary, String type) {
        return this.saveNewModel(newModel, name, summary, type, DEFAULT_STENCILSET, NEW_MODEL_SVG_STRING);
    }

    public String saveNewModel(String newModel, String name, String summary, String type, String stencilset) {
        return this.saveNewModel(newModel, name, summary, type, stencilset, NEW_MODEL_SVG_STRING);
    }

    public String saveNewModel(String newModel, String name, String summary, String type, String stencilset, String svg) {
        UrlEncodedFormEntity formEntity;
        String result = "";
        String url = this.baseUrl + "backend/poem/repository/new?stencilset=" + stencilset;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>(2);
        formParams.add(new BasicNameValuePair("data", newModel));
        formParams.add(new BasicNameValuePair("title", name));
        formParams.add(new BasicNameValuePair("summary", summary));
        formParams.add(new BasicNameValuePair("type", type));
        formParams.add(new BasicNameValuePair("svg", svg));
        try {
            formEntity = new UrlEncodedFormEntity(formParams);
        }
        catch (UnsupportedEncodingException uee) {
            logger.error("Could not encode authentication parameters into request body", (Throwable)uee);
            return result;
        }
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)formEntity);
        try {
            HttpResponse response = client.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != -1) {
                Header[] headers = response.getHeaders("location");
                if (headers.length > 0) {
                    result = headers[0].getValue();
                    if ((result = result.substring(result.lastIndexOf("http://"))).startsWith(this.baseUrl)) {
                        result = result.substring(this.baseUrl.length());
                    }
                } else {
                    logger.error("GET to '{}' failed with status {}", (Object)url, (Object)statusCode);
                }
            } else {
                logger.error("POST to [{}] resulted in status code {} ", (Object)url, (Object)statusCode);
            }
        }
        catch (Exception e) {
            logger.error("POST to [" + url + "] failed: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String saveNewModelErdf(String newModel, String name, ServletContext context) {
        return this.saveNewModel(this.erdfToJson(newModel, context), name, "", DEFAULT_TYPE, DEFAULT_STENCILSET, NEW_MODEL_SVG_STRING);
    }

    public String saveNewModelErdf(String newModel, String name, String summary, ServletContext context) {
        return this.saveNewModel(this.erdfToJson(newModel, context), name, summary, DEFAULT_TYPE, DEFAULT_STENCILSET, NEW_MODEL_SVG_STRING);
    }

    public String saveNewModelErdf(String newModel, String name, String summary, String type, ServletContext context) {
        return this.saveNewModel(this.erdfToJson(newModel, context), name, summary, type, DEFAULT_STENCILSET, NEW_MODEL_SVG_STRING);
    }

    public String saveNewModelErdf(String newModel, String name, String summary, String type, String stencilset, ServletContext context) {
        return this.saveNewModel(this.erdfToJson(newModel, context), name, summary, type, stencilset, NEW_MODEL_SVG_STRING);
    }

    public String saveNewModelErdf(String newModel, String name, String summary, String type, String stencilset, String svg, ServletContext context) {
        return this.saveNewModel(this.erdfToJson(newModel, context), name, summary, type, stencilset, svg);
    }

    public void addTag(String modelUrl, String tagName) {
        if (modelUrl.endsWith("/self")) {
            modelUrl = modelUrl.substring(0, modelUrl.lastIndexOf("/self"));
        }
        String modelTagsUrl = modelUrl + "/tags";
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(modelTagsUrl);
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>(2);
        formParams.add(new BasicNameValuePair("tag_name", tagName));
        try {
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(formParams);
        }
        catch (UnsupportedEncodingException uee) {
            logger.error("Could not encode authentication parameters into request body", (Throwable)uee);
            return;
        }
        try {
            HttpResponse response = client.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == -1) {
                logger.error("POST to [" + modelTagsUrl + "] failed with status code " + statusCode);
            }
        }
        catch (Exception e) {
            logger.error("POST to [" + modelTagsUrl + "] failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String erdfToJson(String erdf, ServletContext context) {
        try {
            String rdf = this.erdfToRdf(erdf, context);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document rdfDoc = builder.parse(new ByteArrayInputStream(rdf.getBytes("UTF-8")));
            return RdfJsonTransformation.toJson(rdfDoc, "").toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    protected String erdfToRdf(String erdf, ServletContext context) throws TransformerException {
        String serializedDOM = "<?xml version=\"1.0\" encoding=\"utf-8\"?><html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:b3mn=\"http://b3mn.org/2007/b3mn\" xmlns:ext=\"http://b3mn.org/2007/ext\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:atom=\"http://b3mn.org/2007/atom+xhtml\"><head profile=\"http://purl.org/NET/erdf/profile\"><link rel=\"schema.dc\" href=\"http://purl.org/dc/elements/1.1/\" /><link rel=\"schema.dcTerms\" href=\"http://purl.org/dc/terms/ \" /><link rel=\"schema.b3mn\" href=\"http://b3mn.org\" /><link rel=\"schema.oryx\" href=\"http://oryx-editor.org/\" /><link rel=\"schema.raziel\" href=\"http://raziel.org/\" /></head><body>" + erdf + "</body></html>";
        InputStream xsltStream = context.getResourceAsStream("/WEB-INF/lib/extract-rdf.xsl");
        StreamSource xsltSource = new StreamSource(xsltStream);
        StreamSource erdfSource = new StreamSource(new StringReader(serializedDOM));
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer trans = transFact.newTransformer(xsltSource);
        StringWriter output = new StringWriter();
        trans.transform(erdfSource, new StreamResult(output));
        return output.toString();
    }
}

