/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.taskforms.builder;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.bpmn2.Definitions;
import org.kie.workbench.common.forms.bpmn.BPMNFormBuilderService;
import org.kie.workbench.common.forms.commons.layout.FormLayoutTemplateGenerator;
import org.kie.workbench.common.forms.jbpm.server.service.BPMNFormModelGenerator;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.service.FormModelHandler;
import org.kie.workbench.common.forms.service.FormModelHandlerManager;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@Dependent
public class BPMNKieWorkbenchFormBuilderService
implements BPMNFormBuilderService<Definitions> {
    private IOService ioService;
    protected FormModelHandlerManager formModelHandlerManager;
    protected BPMNFormModelGenerator generator;
    protected FormDefinitionSerializer serializer;
    protected FormLayoutTemplateGenerator layoutTemplateGenerator;

    @Inject
    public BPMNKieWorkbenchFormBuilderService(@Named(value="ioStrategy") IOService ioService, FormModelHandlerManager formModelHandlerManager, BPMNFormModelGenerator generator, FormDefinitionSerializer serializer, FormLayoutTemplateGenerator layoutTemplateGenerator) {
        this.ioService = ioService;
        this.formModelHandlerManager = formModelHandlerManager;
        this.generator = generator;
        this.serializer = serializer;
        this.layoutTemplateGenerator = layoutTemplateGenerator;
    }

    public String buildFormContent(org.uberfire.backend.vfs.Path formPath, Definitions definition, String taskId) throws Exception {
        Object model = StringUtils.isEmpty((CharSequence)taskId) ? this.generator.generateProcessFormModel(definition) : this.generator.generateTaskFormModel(definition, taskId);
        if (model == null) {
            throw new IllegalArgumentException("Unable to generate form '" + formPath.getFileName() + "'");
        }
        FormDefinition form = this.generateFormForModel((FormModel)model, formPath);
        return this.serializer.serialize(form);
    }

    protected FormDefinition generateFormForModel(FormModel model, org.uberfire.backend.vfs.Path formPath) {
        FormDefinition form;
        Path kiePath = Paths.convert((org.uberfire.backend.vfs.Path)formPath);
        FormModelHandler modelHandler = this.formModelHandlerManager.getFormModelHandler(model.getClass());
        modelHandler.init(model, formPath);
        List modelFields = modelHandler.getAllFormModelFields();
        if (this.ioService.exists(kiePath)) {
            form = this.serializer.deserialize(this.ioService.readAllString(kiePath));
            form.getFields().forEach(originalField -> {
                boolean found = false;
                Iterator it = modelFields.iterator();
                while (it.hasNext() && !found) {
                    FieldDefinition modelField = (FieldDefinition)it.next();
                    if (!modelField.getBinding().equals(originalField.getBinding())) continue;
                    found = true;
                    originalField.setName(modelField.getName());
                    originalField.setStandaloneClassName(modelField.getStandaloneClassName());
                    it.remove();
                }
                if (!found) {
                    originalField.setBinding(null);
                }
            });
            form.getFields().addAll(modelFields);
            this.layoutTemplateGenerator.updateLayoutTemplate(form, modelFields);
        } else {
            form = this.getNewFormInstance();
            form.setName(formPath.getFileName());
            form.getFields().addAll(modelFields);
            this.layoutTemplateGenerator.generateLayoutTemplate(form);
        }
        form.setModel(model);
        return form;
    }

    public String buildEmptyFormContent(String fileName) throws Exception {
        FormDefinition form = this.getNewFormInstance();
        form.setName(fileName);
        return this.serializer.serialize(form);
    }

    protected FormDefinition getNewFormInstance() {
        FormDefinition form = new FormDefinition();
        form.setId(UUID.randomUUID().toString());
        this.layoutTemplateGenerator.generateLayoutTemplate(form);
        return form;
    }

    public String getFormExtension() {
        return "frm";
    }
}

