/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.profile.impl;

import bpsim.impl.BpsimFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.servlet.ServletContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.jackson.JsonParseException;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.bpmn2.util.Bpmn2ResourceFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonMarshaller;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonUnmarshaller;
import org.jbpm.designer.bpmn2.resource.JBPMBpmn2ResourceImpl;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.web.plugin.IDiagramPlugin;
import org.jbpm.designer.web.plugin.impl.PluginServiceImpl;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultProfileImpl
implements IDiagramProfile {
    private static Logger _logger = LoggerFactory.getLogger(DefaultProfileImpl.class);
    private Map<String, IDiagramPlugin> _plugins = new LinkedHashMap<String, IDiagramPlugin>();
    private String stencilSet;
    private String localHistoryEnabled;
    private String localHistoryTimeout;
    private String repositoryId;
    private String repositoryRoot;
    private String repositoryName;
    private String repositoryHost;
    private String repositoryProtocol;
    private String repositorySubdomain;
    private String repositoryUsr;
    private String repositoryPwd;
    private String repositoryGlobalDir;
    private String formsType;

    public DefaultProfileImpl() {
    }

    public DefaultProfileImpl(ServletContext servletContext) {
        this(servletContext, true);
    }

    public DefaultProfileImpl(ServletContext servletContext, boolean initializeLocalPlugins) {
        if (initializeLocalPlugins) {
            this.initializeLocalPlugins(servletContext);
        }
    }

    @Override
    public String getTitle() {
        return "Process Designer";
    }

    @Override
    public String getStencilSet() {
        return this.stencilSet;
    }

    @Override
    public Collection<String> getStencilSetExtensions() {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getPlugins() {
        return Collections.unmodifiableCollection(this._plugins.keySet());
    }

    private void initializeLocalPlugins(ServletContext context) {
        Map<String, IDiagramPlugin> registry = PluginServiceImpl.getLocalPluginsRegistry(context);
        FileInputStream fileStream = null;
        try {
            try {
                fileStream = new FileInputStream(context.getRealPath("/") + "/" + ConfigurationProvider.getInstance().getDesignerContext() + "profiles" + "/" + "default.xml");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(fileStream, "UTF-8");
            while (reader.hasNext()) {
                if (reader.next() != 1) continue;
                if ("profile".equals(reader.getLocalName())) {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        if (!"stencilset".equals(reader.getAttributeLocalName(i))) continue;
                        this.stencilSet = reader.getAttributeValue(i);
                    }
                    continue;
                }
                if (!"plugin".equals(reader.getLocalName())) continue;
                String name = null;
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    if (!"name".equals(reader.getAttributeLocalName(i))) continue;
                    name = reader.getAttributeValue(i);
                }
                this._plugins.put(name, registry.get(name));
            }
        }
        catch (XMLStreamException e) {
            _logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String getName() {
        return "default";
    }

    @Override
    public String getSerializedModelExtension() {
        return "bpmn";
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryHost() {
        return this.repositoryHost;
    }

    public String getRepositoryProtocol() {
        return this.repositoryProtocol;
    }

    public String getRepositorySubdomain() {
        return this.repositorySubdomain;
    }

    public String getRepositoryUsr() {
        return this.repositoryUsr;
    }

    public String getRepositoryPwd() {
        return this.repositoryPwd;
    }

    @Override
    public String getRepositoryGlobalDir() {
        return this.repositoryGlobalDir;
    }

    @Override
    public String getRepositoryGlobalDir(String uuid) {
        return this.repositoryGlobalDir;
    }

    @Override
    public String getLocalHistoryEnabled() {
        return this.localHistoryEnabled;
    }

    @Override
    public String getLocalHistoryTimeout() {
        return this.localHistoryTimeout;
    }

    @Override
    public String getStoreSVGonSaveOption() {
        return "false";
    }

    @Override
    public String getFormsType() {
        return this.formsType;
    }

    @Override
    public Repository getRepository() {
        return null;
    }

    @Override
    public void init(ServletContext context) {
    }

    @Override
    public IDiagramProfile.IDiagramMarshaller createMarshaller() {
        return new IDiagramProfile.IDiagramMarshaller(){

            @Override
            public String parseModel(String jsonModel, String preProcessingData) {
                Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                try {
                    Bpmn2Resource res = unmarshaller.unmarshall(jsonModel, preProcessingData);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    HashMap<String, Object> saveMap = new HashMap<String, Object>();
                    saveMap.put("ENCODING", "UTF-8");
                    saveMap.put("DEFER_IDREF_RESOLUTION", true);
                    saveMap.put("DISABLE_NOTIFY", true);
                    saveMap.put("PROCESS_DANGLING_HREF", "RECORD");
                    res.save((OutputStream)outputStream, saveMap);
                    return outputStream.toString();
                }
                catch (JsonParseException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                return "";
            }

            @Override
            public Definitions getDefinitions(String jsonModel, String preProcessingData) {
                try {
                    Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                    JBPMBpmn2ResourceImpl res = (JBPMBpmn2ResourceImpl)unmarshaller.unmarshall(jsonModel, preProcessingData);
                    return (Definitions)res.getContents().get(0);
                }
                catch (JsonParseException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                return null;
            }

            @Override
            public Resource getResource(String jsonModel, String preProcessingData) {
                try {
                    Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                    return (JBPMBpmn2ResourceImpl)unmarshaller.unmarshall(jsonModel, preProcessingData);
                }
                catch (JsonParseException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                return null;
            }
        };
    }

    @Override
    public IDiagramProfile.IDiagramUnmarshaller createUnmarshaller() {
        return new IDiagramProfile.IDiagramUnmarshaller(){

            @Override
            public String parseModel(String xmlModel, IDiagramProfile profile, String preProcessingData) {
                Bpmn2JsonMarshaller marshaller = new Bpmn2JsonMarshaller();
                marshaller.setProfile(profile);
                try {
                    return marshaller.marshall(DefaultProfileImpl.this.getDefinitions(xmlModel), preProcessingData);
                }
                catch (Exception e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                    return "";
                }
            }
        };
    }

    private Definitions getDefinitions(String xml) {
        try {
            DroolsFactoryImpl.init();
            BpsimFactoryImpl.init();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new Bpmn2ResourceFactoryImpl());
            resourceSet.getPackageRegistry().put((Object)"http://www.omg.org/spec/BPMN/20100524/MODEL", (Object)Bpmn2Package.eINSTANCE);
            Resource resource = resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            resource.load((InputStream)is, Collections.EMPTY_MAP);
            resource.load(Collections.EMPTY_MAP);
            return ((DocumentRoot)resource.getContents().get(0)).getDefinitions();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @Override
    public String getStencilSetURL() {
        return "/org.jbpm.designer.jBPMDesigner/stencilsets/bpmn2.0/bpmn2.0.json";
    }

    @Override
    public String getStencilSetNamespaceURL() {
        return "http://b3mn.org/stencilset/bpmn2.0#";
    }

    @Override
    public String getStencilSetExtensionURL() {
        return "http://oryx-editor.org/stencilsets/extensions/bpmncosts-2.0#";
    }
}

