/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.service;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.server.service.DefaultDesignerAssetService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.ResourceOpenedEvent;

public class DesignerAssetServiceTest
extends RepositoryBaseTest {
    private final List<Object> receivedEvents = new ArrayList<Object>();
    private Event<ResourceOpenedEvent> resourceOpenedEvent = new EventSourceMock<ResourceOpenedEvent>(){

        public void fire(ResourceOpenedEvent event) {
            DesignerAssetServiceTest.this.receivedEvents.add(event);
        }
    };
    @Mock
    private ResourceOpenedEvent testResourceOpenedEvent;

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testGetEditorParameters() throws Exception {
        DefaultDesignerAssetService assetService = (DefaultDesignerAssetService)Mockito.mock(DefaultDesignerAssetService.class);
        PlaceRequest readOnlyPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        PlaceRequest readPlaceRequst = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)readOnlyPlaceRequest.getParameter(Matchers.anyString(), Matchers.anyString())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return "true";
            }
        });
        Mockito.when((Object)readPlaceRequst.getParameter(Matchers.anyString(), Matchers.anyString())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return "false";
            }
        });
        Mockito.when((Object)assetService.getEditorParameters((Path)Matchers.anyObject(), Matchers.anyString(), Matchers.anyString(), (PlaceRequest)Matchers.anyObject())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                PlaceRequest place = (PlaceRequest)args[3];
                if (place.getParameter("readonly", "false").equals("true")) {
                    DesignerAssetServiceTest.this.resourceOpenedEvent.fire((Object)DesignerAssetServiceTest.this.testResourceOpenedEvent);
                }
                return null;
            }
        });
        assetService.getEditorParameters(null, null, null, readPlaceRequst);
        Assert.assertEquals((long)this.receivedEvents.size(), (long)0L);
        assetService.getEditorParameters(null, null, null, readOnlyPlaceRequest);
        Assert.assertEquals((long)this.receivedEvents.size(), (long)1L);
    }
}

