/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.filter;

import com.google.common.base.Charsets;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.uberfire.ext.security.server.BasicAuthSecurityFilter;

public class DesignerBasicAuthSecurityFilter
extends BasicAuthSecurityFilter
implements Filter {
    @Inject
    AuthenticationService authenticationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest _request, ServletResponse _response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)_request;
        HttpServletResponse response = (HttpServletResponse)_response;
        HttpSession session = request.getSession(false);
        User user = this.authenticationService.getUser();
        if (request.getMethod().equals("OPTIONS")) {
            response.setStatus(202);
            return;
        }
        try {
            if (user == null) {
                if (this.authenticate(request)) {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    if (response.isCommitted()) {
                        this.authenticationService.logout();
                    }
                } else {
                    this.challengeClient(request, response);
                }
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            if (session == null && (session = request.getSession(false)) != null) {
                session.invalidate();
            }
        }
    }

    public void challengeClient(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getMethod().equals("OPTIONS")) {
            response.setStatus(202);
        } else {
            super.challengeClient(request, response);
        }
    }

    public boolean authenticate(HttpServletRequest req) {
        if (req.getMethod().equals("OPTIONS")) {
            return true;
        }
        String authHead = req.getHeader("Authorization");
        if (authHead != null) {
            int index = authHead.indexOf(32);
            String[] credentials = new String(Base64.decodeBase64((String)authHead.substring(index)), Charsets.UTF_8).split(":", -1);
            try {
                this.authenticationService.login(credentials[0], credentials[1]);
                return true;
            }
            catch (FailedAuthenticationException var6) {
                return false;
            }
        }
        return false;
    }
}

