/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.taskforms.builder;

import java.util.UUID;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.bpmn2.Definitions;
import org.kie.workbench.common.forms.bpmn.BPMNFormBuilderService;
import org.kie.workbench.common.forms.commons.shared.layout.FormLayoutTemplateGenerator;
import org.kie.workbench.common.forms.editor.service.backend.FormModelHandlerManager;
import org.kie.workbench.common.forms.jbpm.model.authoring.JBPMFormModel;
import org.kie.workbench.common.forms.jbpm.server.service.BPMNFormModelGenerator;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.BPMNFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.authoring.Authoring;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;

@Dependent
public class BPMNKieWorkbenchFormBuilderService
implements BPMNFormBuilderService<Definitions> {
    private IOService ioService;
    protected FormModelHandlerManager formModelHandlerManager;
    protected BPMNFormModelGenerator generator;
    protected FormDefinitionSerializer serializer;
    protected FormLayoutTemplateGenerator layoutTemplateGenerator;
    protected BPMNFormGeneratorService<Path> bpmnFormGeneratorService;

    @Inject
    public BPMNKieWorkbenchFormBuilderService(@Named(value="ioStrategy") IOService ioService, FormModelHandlerManager formModelHandlerManager, BPMNFormModelGenerator generator, FormDefinitionSerializer serializer, FormLayoutTemplateGenerator layoutTemplateGenerator, @Authoring BPMNFormGeneratorService<Path> bpmnFormGeneratorService) {
        this.ioService = ioService;
        this.formModelHandlerManager = formModelHandlerManager;
        this.generator = generator;
        this.serializer = serializer;
        this.layoutTemplateGenerator = layoutTemplateGenerator;
        this.bpmnFormGeneratorService = bpmnFormGeneratorService;
    }

    public String buildFormContent(Path formPath, Definitions definition, String taskId) throws Exception {
        Object model = StringUtils.isEmpty((CharSequence)taskId) ? this.generator.generateProcessFormModel(definition, formPath) : this.generator.generateTaskFormModel(definition, taskId, formPath);
        if (model == null) {
            throw new IllegalArgumentException("Unable to generate form '" + formPath.getFileName() + "'");
        }
        FormDefinition form = this.bpmnFormGeneratorService.generateForms((JBPMFormModel)model, (Object)formPath).getRootForm();
        return this.serializer.serialize(form);
    }

    public String buildEmptyFormContent(String fileName) throws Exception {
        FormDefinition form = this.getNewFormInstance();
        form.setName(fileName);
        return this.serializer.serialize(form);
    }

    protected FormDefinition getNewFormInstance() {
        FormDefinition form = new FormDefinition();
        form.setId(UUID.randomUUID().toString());
        this.layoutTemplateGenerator.generateLayoutTemplate(form);
        return form;
    }

    public String getFormExtension() {
        return "frm";
    }
}

