/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.server.ProcessDiffServiceServlet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessDiffServiceServletTest
extends RepositoryBaseTest {
    @Mock
    IDiagramProfileService profileService;
    @Spy
    @InjectMocks
    private ProcessDiffServiceServlet servlet = new ProcessDiffServiceServlet();

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.profileService.findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString())).thenReturn((Object)this.profile);
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testDoPostFindProfile() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        try {
            this.servlet.doPost(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.times((int)1))).findProfile(request, "jbpm");
    }

    @Test
    public void testDoPostProfileAlreadySet() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.servlet.profile = this.profile;
        try {
            this.servlet.doPost(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.never())).findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString());
    }
}

