/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.bpmn2.Definitions;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.helper.TestServletConfig;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.taskforms.BPMNFormBuilderManager;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.server.TaskFormsServlet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.forms.bpmn.BPMNFormBuilderService;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSService;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskFormsServletTest
extends RepositoryBaseTest {
    @Mock
    protected VFSService vfsServices;
    @Mock
    protected BPMNFormBuilderService<Definitions> formBuilderService;
    @Mock
    protected BPMNFormBuilderManager builderManager;
    @InjectMocks
    TaskFormsServlet taskFormsServlet;
    protected String dirName = "defaultPackage";
    protected String processFileName = "process";

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.vfsServices.get((String)Matchers.any())).thenAnswer((Answer)new Answer<Path>(){

            public Path answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return PathFactory.newPath((String)((String)args[0]), (String)((String)args[0]));
            }
        });
        Mockito.when((Object)this.builderManager.getFormBuilders()).thenReturn(Arrays.asList(this.formBuilderService));
        Mockito.when((Object)this.builderManager.getBuilderByFormType(Mockito.anyString())).thenReturn(this.formBuilderService);
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testTaskFormServletForFormType() throws Exception {
        Mockito.when((Object)this.formBuilderService.getFormExtension()).thenReturn((Object)"form");
        Mockito.when((Object)this.formBuilderService.buildFormContent((Path)Matchers.any(), Matchers.any(), (String)Matchers.any())).thenReturn((Object)"dummyform");
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name(this.processFileName).location("/" + this.dirName);
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("json", this.readFile("BPMN2-DefaultProcess.json"));
        params.put("profile", "jbpm");
        params.put("ppdata", null);
        params.put("formtype", "form");
        this.taskFormsServlet.setProfile((IDiagramProfile)this.profile);
        this.taskFormsServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository, "org/jbpm/designer/public")));
        this.taskFormsServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection formForms = repository.listAssets("/" + this.dirName, (Filter)new FilterByExtension("form"));
        Assert.assertEquals((long)0L, (long)formForms.size());
    }

    @Test
    public void testTaskFormServletForFrmType() throws Exception {
        Mockito.when((Object)this.formBuilderService.getFormExtension()).thenReturn((Object)"frm");
        Mockito.when((Object)this.formBuilderService.buildFormContent((Path)Matchers.any(), Matchers.any(), (String)Matchers.any())).thenReturn((Object)"dummyform");
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name(this.processFileName).location("/" + this.dirName);
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("json", this.readFile("BPMN2-DefaultProcess.json"));
        params.put("profile", "jbpm");
        params.put("ppdata", null);
        params.put("formtype", "frm");
        this.taskFormsServlet.setProfile((IDiagramProfile)this.profile);
        this.taskFormsServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository, "org/jbpm/designer/public")));
        this.taskFormsServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection frmForms = repository.listAssets("/" + this.dirName, (Filter)new FilterByExtension("frm"));
        Assert.assertEquals((long)1L, (long)frmForms.size());
    }

    @Test
    public void testTaskFormServletWithUserTaskForFormType() throws Exception {
        Mockito.when((Object)this.formBuilderService.buildFormContent((Path)Matchers.any(), Matchers.any(), (String)Matchers.any())).thenReturn((Object)"dummyform");
        Mockito.when((Object)this.formBuilderService.getFormExtension()).thenReturn((Object)"form");
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name(this.processFileName).location("/" + this.dirName);
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("json", this.readFile("BPMN2-UserTask.json"));
        params.put("profile", "jbpm");
        params.put("ppdata", null);
        params.put("formtype", "form");
        this.taskFormsServlet.setProfile((IDiagramProfile)this.profile);
        this.taskFormsServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository, "org/jbpm/designer/public")));
        this.taskFormsServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection formForms = repository.listAssets("/" + this.dirName, (Filter)new FilterByExtension("form"));
        Assert.assertEquals((long)0L, (long)formForms.size());
    }

    @Test
    public void testTaskFormServletWithUserTaskForFrmType() throws Exception {
        Mockito.when((Object)this.formBuilderService.getFormExtension()).thenReturn((Object)"frm");
        Mockito.when((Object)this.formBuilderService.buildFormContent((Path)Matchers.any(), Matchers.any(), (String)Matchers.any())).thenReturn((Object)"dummyform");
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name(this.processFileName).location("/" + this.dirName);
        String uniqueId = repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("json", this.readFile("BPMN2-UserTask.json"));
        params.put("profile", "jbpm");
        params.put("ppdata", null);
        params.put("formtype", "frm");
        this.taskFormsServlet.setProfile((IDiagramProfile)this.profile);
        this.taskFormsServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository, "org/jbpm/designer/public")));
        this.taskFormsServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection frmForms = repository.listAssets("/" + this.dirName, (Filter)new FilterByExtension("frm"));
        Assert.assertEquals((long)2L, (long)frmForms.size());
    }

    @Test
    public void testWithUserTaskForExistingFrmType() throws Exception {
        Mockito.when((Object)this.formBuilderService.getFormExtension()).thenReturn((Object)"frm");
        Mockito.when((Object)this.formBuilderService.buildFormContent((Path)Matchers.any(), Matchers.any(), (String)Matchers.any())).thenReturn((Object)"dummyform");
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name(this.processFileName).location("/" + this.dirName);
        String uniqueId = repository.createAsset(builder.getAsset());
        AssetBuilder formBuilder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        formBuilder.content((Object)"form content".getBytes()).type("frm").name("evaluate-taskform").location("/" + this.dirName);
        repository.createAsset(formBuilder.getAsset());
        AssetBuilder formBuilder2 = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Byte);
        formBuilder2.content((Object)"form content".getBytes()).type("frm").name("testprocess-taskform").location("/" + this.dirName);
        repository.createAsset(formBuilder2.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        params.put("json", this.readFile("BPMN2-UserTask.json"));
        params.put("profile", "jbpm");
        params.put("ppdata", null);
        params.put("formtype", "frm");
        this.taskFormsServlet.setProfile((IDiagramProfile)this.profile);
        this.taskFormsServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository, "org/jbpm/designer/public")));
        this.taskFormsServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)new TestHttpServletResponse());
        Collection frmForms = repository.listAssets("/" + this.dirName, (Filter)new FilterByExtension("frm"));
        Assert.assertEquals((long)2L, (long)frmForms.size());
    }

    private String readFile(String fileName) throws Exception {
        URL fileURL = TaskFormsServletTest.class.getResource(fileName);
        return new String(Files.readAllBytes(Paths.get(fileURL.toURI())));
    }
}

