/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.shared;

import org.jbpm.designer.client.DesignerPresenter;
import org.jbpm.designer.client.DesignerView;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;

public class ViewLockTest {
    private VersionRecordManager versionRecordManager;
    private UpdatedLockStatusEvent updatedLockStatusEvent;
    private DesignerView designerView;
    private ObservablePath path;
    private ObservablePath otherPath;

    @Before
    public void setUp() {
        this.designerView = (DesignerView)Mockito.mock(DesignerView.class);
        this.updatedLockStatusEvent = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        this.versionRecordManager = (VersionRecordManager)Mockito.mock(VersionRecordManager.class);
        this.path = (ObservablePath)Mockito.mock(ObservablePath.class);
        this.otherPath = (ObservablePath)Mockito.mock(ObservablePath.class);
    }

    @Test
    public void testOnLockChangeOnSamePath() {
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)this.path);
        Mockito.when((Object)this.updatedLockStatusEvent.getFile()).thenReturn((Object)this.path);
        DesignerPresenter designerPresenter = new DesignerPresenter(this.designerView);
        designerPresenter.setVersionRecordManager(this.versionRecordManager);
        designerPresenter.onLockChange(this.updatedLockStatusEvent);
        ((DesignerView)Mockito.verify((Object)this.designerView, (VerificationMode)Mockito.times((int)1))).raiseEventUpdateLock();
    }

    @Test
    public void testOnLockChangeOnDifferentPath() {
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)this.path);
        Mockito.when((Object)this.updatedLockStatusEvent.getFile()).thenReturn((Object)this.otherPath);
        DesignerPresenter designerPresenter = new DesignerPresenter(this.designerView);
        designerPresenter.setVersionRecordManager(this.versionRecordManager);
        designerPresenter.onLockChange(this.updatedLockStatusEvent);
        ((DesignerView)Mockito.verify((Object)this.designerView, (VerificationMode)Mockito.times((int)0))).raiseEventUpdateLock();
    }
}

