/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.notification;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.designer.notification.DesignerNotificationEvent;
import org.uberfire.client.views.pfly.notifications.NotificationPopupView;
import org.uberfire.client.workbench.widgets.animations.LinearFadeOutAnimation;

@ApplicationScoped
public class DesignerNotificationPopupsManager {
    @Inject
    private SyncBeanManager iocManager;
    @Inject
    private User user;
    private boolean removing = false;
    private static final int SPACING = 48;
    private List<NotificationPopupView> activeNotifications = new ArrayList<NotificationPopupView>();
    private List<NotificationPopupView> deactiveNotifications = new ArrayList<NotificationPopupView>();

    public void addNotification(@Observes DesignerNotificationEvent event) {
        if (this.user.getIdentifier().equals(event.getUserId()) && event.getNotification() != null && !event.getNotification().equals("openinxmleditor")) {
            final NotificationPopupView view = (NotificationPopupView)this.iocManager.lookupBean(NotificationPopupView.class, new Annotation[0]).getInstance();
            this.activeNotifications.add(view);
            view.setPopupPosition(this.getMargin(), this.activeNotifications.size() * 48);
            view.setNotification(event.getNotification());
            view.setType(event.getType());
            view.setNotificationWidth(this.getWidth() + "px");
            view.show(new Command(){

                public void execute() {
                    DesignerNotificationPopupsManager.this.deactiveNotifications.add(view);
                    DesignerNotificationPopupsManager.this.remove();
                }
            });
        }
    }

    private int getWidth() {
        return (int)((double)Window.getClientWidth() * 0.8);
    }

    private int getMargin() {
        return (Window.getClientWidth() - this.getWidth()) / 2;
    }

    private void remove() {
        if (this.removing) {
            return;
        }
        if (this.deactiveNotifications.size() == 0) {
            return;
        }
        this.removing = true;
        final NotificationPopupView view = this.deactiveNotifications.get(0);
        LinearFadeOutAnimation fadeOutAnimation = new LinearFadeOutAnimation((Widget)view){

            public void onUpdate(double progress) {
                super.onUpdate(progress);
                for (int i = 0; i < DesignerNotificationPopupsManager.this.activeNotifications.size(); ++i) {
                    NotificationPopupView v = (NotificationPopupView)DesignerNotificationPopupsManager.this.activeNotifications.get(i);
                    int left = v.getPopupLeft();
                    int top = (int)((double)((i + 1) * 48) - progress * 48.0);
                    v.setPopupPosition(left, top);
                }
            }

            public void onComplete() {
                super.onComplete();
                view.hide();
                DesignerNotificationPopupsManager.this.deactiveNotifications.remove(view);
                DesignerNotificationPopupsManager.this.activeNotifications.remove(view);
                DesignerNotificationPopupsManager.this.iocManager.destroyBean((Object)view);
                DesignerNotificationPopupsManager.this.removing = false;
                DesignerNotificationPopupsManager.this.remove();
            }
        };
        fadeOutAnimation.run(500);
    }
}

