/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwtmockito.GwtMockito;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.designer.client.util.DataIOEditorNameTextBox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class DataIOEditorNameTextBoxTest {
    private static final String ALPHA_NUM_REGEXP = "^[a-zA-Z0-9\\-\\.\\_]*$";
    private static final String ERROR_MESSAGE = "some error";
    private static final String ERROR_REMOVED = "some error reg exp";
    private static final String ERROR_TYPED = "some error reg exp2";
    private static final Set<String> INVALID_VALUES = new HashSet<String>();
    @Captor
    private ArgumentCaptor<BlurHandler> blurCaptor;
    @Captor
    ArgumentCaptor<KeyPressHandler> keyPressCaptor;
    @Mock
    private BlurEvent blurEvent;
    @Mock
    private KeyPressEvent keyPressEvent;
    @Mock
    private NativeEvent nativeEvent;
    private boolean caseSensitive;
    private DataIOEditorNameTextBox textBox;

    @Parameterized.Parameters
    public static Collection<Boolean[]> caseSensitivity() {
        return Arrays.asList({true}, {false});
    }

    public DataIOEditorNameTextBoxTest(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Before
    public void init() {
        GwtMockito.initMocks((Object)this);
        this.textBox = (DataIOEditorNameTextBox)GWT.create(DataIOEditorNameTextBox.class);
        ((DataIOEditorNameTextBox)Mockito.doCallRealMethod().when((Object)this.textBox)).setRegExp(Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
        ((DataIOEditorNameTextBox)Mockito.doCallRealMethod().when((Object)this.textBox)).setInvalidValues(Mockito.anySet(), Mockito.anyBoolean(), Mockito.anyString());
        ((DataIOEditorNameTextBox)Mockito.doCallRealMethod().when((Object)this.textBox)).isValidValue(Mockito.anyString(), Mockito.anyBoolean());
        ((DataIOEditorNameTextBox)Mockito.doCallRealMethod().when((Object)this.textBox)).setText(Mockito.anyString());
        ((DataIOEditorNameTextBox)Mockito.doCallRealMethod().when((Object)this.textBox)).testForInvalidValue(Mockito.anyString());
        ((DataIOEditorNameTextBox)Mockito.doCallRealMethod().when((Object)this.textBox)).makeValidValue(Mockito.anyString());
        ((DataIOEditorNameTextBox)Mockito.doCallRealMethod().when((Object)this.textBox)).getInvalidCharsInName(Mockito.anyString());
        ((DataIOEditorNameTextBox)Mockito.doCallRealMethod().when((Object)this.textBox)).isValidChar(Mockito.anyChar());
        ((DataIOEditorNameTextBox)Mockito.doCallRealMethod().when((Object)this.textBox)).setup();
        ((DataIOEditorNameTextBox)Mockito.doCallRealMethod().when((Object)this.textBox)).addBlurHandler((BlurHandler)Mockito.any(BlurHandler.class));
        ((DataIOEditorNameTextBox)Mockito.doCallRealMethod().when((Object)this.textBox)).addKeyPressHandler((KeyPressHandler)Mockito.any(KeyPressHandler.class));
        this.textBox.setRegExp(ALPHA_NUM_REGEXP, ERROR_REMOVED, ERROR_TYPED);
        INVALID_VALUES.clear();
        INVALID_VALUES.add("abc");
        INVALID_VALUES.add("CdE");
        INVALID_VALUES.add("a#$%1");
        this.textBox.setInvalidValues(INVALID_VALUES, this.caseSensitive, ERROR_MESSAGE);
    }

    @Test
    public void testSetup() {
        Mockito.when((Object)this.textBox.getKeyCodeFromKeyPressEvent((KeyPressEvent)Mockito.any(KeyPressEvent.class))).thenReturn((Object)64);
        Mockito.when((Object)this.keyPressEvent.isControlKeyDown()).thenReturn((Object)false);
        Mockito.when((Object)this.keyPressEvent.isShiftKeyDown()).thenReturn((Object)true);
        Mockito.when((Object)Character.valueOf(this.keyPressEvent.getCharCode())).thenReturn((Object)Character.valueOf('@'));
        Mockito.when((Object)this.textBox.getCursorPos()).thenReturn((Object)4);
        Mockito.when((Object)this.textBox.getSelectionLength()).thenReturn((Object)0);
        Mockito.when((Object)this.textBox.getValue()).thenReturn((Object)"ab12");
        Mockito.when((Object)this.textBox.getText()).thenReturn((Object)"ab12@");
        this.textBox.setup();
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.textBox, (VerificationMode)Mockito.times((int)1))).addBlurHandler((BlurHandler)this.blurCaptor.capture());
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.textBox, (VerificationMode)Mockito.times((int)1))).addKeyPressHandler((KeyPressHandler)this.keyPressCaptor.capture());
        BlurHandler blurHandler = (BlurHandler)this.blurCaptor.getValue();
        blurHandler.onBlur(this.blurEvent);
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.textBox, (VerificationMode)Mockito.times((int)1))).isValidValue("ab12@", true);
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.textBox, (VerificationMode)Mockito.times((int)1))).makeValidValue("ab12@");
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.textBox, (VerificationMode)Mockito.times((int)1))).setValue((Object)"ab12");
        KeyPressHandler keyPressHandler = (KeyPressHandler)this.keyPressCaptor.getValue();
        keyPressHandler.onKeyPress(this.keyPressEvent);
        ((KeyPressEvent)Mockito.verify((Object)this.keyPressEvent, (VerificationMode)Mockito.times((int)1))).preventDefault();
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.textBox, (VerificationMode)Mockito.times((int)1))).isValidValue("ab12@", false);
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.textBox, (VerificationMode)Mockito.times((int)1))).fireValidationError("some error reg exp: @");
        ((DataIOEditorNameTextBox)Mockito.verify((Object)this.textBox, (VerificationMode)Mockito.times((int)1))).fireValidationError("some error reg exp2: @");
    }

    @Test
    public void testMakeValid() {
        String makeValidResult = this.textBox.makeValidValue(null);
        Assert.assertEquals((Object)"", (Object)makeValidResult);
        makeValidResult = this.textBox.makeValidValue("");
        Assert.assertEquals((Object)"", (Object)makeValidResult);
        makeValidResult = this.textBox.makeValidValue("aBc");
        if (this.caseSensitive) {
            Assert.assertEquals((Object)"aBc", (Object)makeValidResult);
        } else {
            Assert.assertEquals((Object)"", (Object)makeValidResult);
        }
        makeValidResult = this.textBox.makeValidValue("CdE");
        Assert.assertEquals((Object)"", (Object)makeValidResult);
        makeValidResult = this.textBox.makeValidValue("c");
        Assert.assertEquals((Object)"c", (Object)makeValidResult);
        makeValidResult = this.textBox.makeValidValue("a#b$2%1");
        Assert.assertEquals((Object)"ab21", (Object)makeValidResult);
    }

    @Test
    public void testIsValidValue() {
        String isValidResult = this.textBox.isValidValue("a", true);
        Assert.assertEquals(null, (Object)isValidResult);
        isValidResult = this.textBox.isValidValue("a", false);
        Assert.assertEquals(null, (Object)isValidResult);
        isValidResult = this.textBox.isValidValue("aBc", true);
        if (this.caseSensitive) {
            Assert.assertEquals(null, (Object)isValidResult);
        } else {
            Assert.assertEquals((Object)ERROR_MESSAGE, (Object)isValidResult);
        }
        isValidResult = this.textBox.isValidValue("aBc", false);
        Assert.assertEquals(null, (Object)isValidResult);
        isValidResult = this.textBox.isValidValue("CdE", true);
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)isValidResult);
        isValidResult = this.textBox.isValidValue("CdE", false);
        Assert.assertEquals(null, (Object)isValidResult);
        isValidResult = this.textBox.isValidValue("a#$%1", true);
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)isValidResult);
        isValidResult = this.textBox.isValidValue("a#$%1", false);
        Assert.assertEquals((Object)"some error reg exp2: #$%", (Object)isValidResult);
    }
}

