/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.designer.client.DesignerWidgetPresenter;
import org.jbpm.designer.client.parameters.DesignerEditorParametersPublisher;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.service.DesignerAssetService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchPopup;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@Dependent
@WorkbenchPopup(identifier="jbpm.designer.popup", size=WorkbenchPopup.WorkbenchPopupSize.LARGE)
public class DesignerPopUpPresenter
extends Composite
implements RequiresResize {
    @Inject
    private DesignerWidgetPresenter designerWidget;
    @Inject
    private Caller<DesignerAssetService> assetService;
    @Inject
    private DesignerEditorParametersPublisher designerEditorParametersPublisher;
    protected boolean isReadOnly;
    private FlowPanel container = new FlowPanel();

    @PostConstruct
    public void init() {
        this.container.clear();
        this.container.add(this.designerWidget.getView());
    }

    @OnOpen
    public void onOpen() {
        this.designerWidget.setSize(1000, 600);
    }

    @OnStartup
    public void onStartup(final PlaceRequest place) {
        this.isReadOnly = true;
        if (place instanceof PathPlaceRequest) {
            ((DesignerAssetService)this.assetService.call((RemoteCallback)new RemoteCallback<String>(){

                public void callback(final String editorID) {
                    String url = GWT.getHostPageBaseURL().replaceFirst("/" + GWT.getModuleName() + "/", "");
                    ((DesignerAssetService)DesignerPopUpPresenter.this.assetService.call((RemoteCallback)new RemoteCallback<Map<String, String>>(){

                        public void callback(Map<String, String> editorParameters) {
                            if (editorParameters != null) {
                                if (editorParameters.containsKey("readonly")) {
                                    DesignerPopUpPresenter.this.isReadOnly = Boolean.valueOf(editorParameters.get("readonly"));
                                }
                                DesignerPopUpPresenter.this.designerEditorParametersPublisher.publish(editorParameters);
                                DesignerPopUpPresenter.this.designerWidget.setup(editorID, editorParameters);
                            }
                        }
                    })).getEditorParameters((Path)((PathPlaceRequest)place).getPath(), editorID, url, place);
                }
            })).getEditorID();
        }
    }

    @WorkbenchPartTitle
    public String getName() {
        return DesignerEditorConstants.INSTANCE.ProcessModel();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.container;
    }

    public void onResize() {
        int height = this.getContainer().getParent().getOffsetHeight();
        int width = this.getContainer().getParent().getOffsetWidth();
        this.getContainer().setWidth(width + "px");
        this.getContainer().setHeight(height + "px");
    }

    public FlowPanel getContainer() {
        return this.container;
    }
}

