/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.designer.client.DesignerPresenter;
import org.jbpm.designer.client.DesignerView;
import org.jbpm.designer.client.parameters.DesignerEditorParametersPublisher;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.integration.client.IntegrationHandler;
import org.kie.workbench.common.stunner.bpmn.integration.client.IntegrationHandlerProvider;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilderImpl;
import org.kie.workbench.common.widgets.metadata.client.validation.AssetUpdateValidator;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.promise.SyncPromises;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class DesignerPresenterTest {
    @Mock
    protected BasicFileMenuBuilder menuBuilder;
    @Mock
    protected VersionRecordManager versionRecordManager;
    @Spy
    @InjectMocks
    protected FileMenuBuilderImpl fileMenuBuilder;
    @Mock
    protected ProjectController projectController;
    @Mock
    protected WorkspaceProjectContext workbenchContext;
    @Mock
    private RenameService renameService;
    private CallerMock<RenameService> renameServiceCaller;
    @Mock
    private DesignerView view;
    @Mock
    private Overview overview;
    @Mock
    private DesignerEditorParametersPublisher designerEditorParametersPublisher;
    @Mock
    private RenamePopUpPresenter renamePopUpPresenter;
    @Mock
    private DefaultFileNameValidator fileNameValidator;
    @Mock
    private BaseEditorView baseView;
    @Mock
    private AlertsButtonMenuItemBuilder alertsButtonMenuItemBuilder;
    private Promises promises;
    @Mock
    private MenuItem alertsButtonMenuItem;
    @Mock
    private IntegrationHandlerProvider integrationHandlerProvider;
    @Mock
    private IntegrationHandler integrationHandler;
    @Captor
    private ArgumentCaptor<ClickHandler> clickHandlerCaptor;
    private Button migrateButton;
    @Mock
    private PlaceRequest place;
    @Spy
    private Map<String, String> parameters = new HashMap<String, String>();
    private DesignerPresenter presenter;

    @Before
    public void setup() {
        this.migrateButton = (Button)Mockito.mock(Button.class);
        Mockito.when((Object)this.integrationHandlerProvider.getIntegrationHandler()).thenReturn(Optional.empty());
        this.promises = new SyncPromises();
        Mockito.when((Object)this.alertsButtonMenuItemBuilder.build()).thenReturn((Object)this.alertsButtonMenuItem);
        this.renameServiceCaller = new CallerMock((Object)this.renameService);
        this.presenter = (DesignerPresenter)Mockito.spy((Object)new DesignerPresenter(this.view){
            {
                this.fileMenuBuilder = DesignerPresenterTest.this.fileMenuBuilder;
                this.projectController = DesignerPresenterTest.this.projectController;
                this.workbenchContext = DesignerPresenterTest.this.workbenchContext;
                this.versionRecordManager = DesignerPresenterTest.this.versionRecordManager;
                this.designerEditorParametersPublisher = DesignerPresenterTest.this.designerEditorParametersPublisher;
                this.renamePopUpPresenter = DesignerPresenterTest.this.renamePopUpPresenter;
                this.fileNameValidator = DesignerPresenterTest.this.fileNameValidator;
                this.baseView = DesignerPresenterTest.this.baseView;
                this.alertsButtonMenuItemBuilder = DesignerPresenterTest.this.alertsButtonMenuItemBuilder;
                this.promises = DesignerPresenterTest.this.promises;
                this.integrationHandlerProvider = DesignerPresenterTest.this.integrationHandlerProvider;
                this.place = DesignerPresenterTest.this.place;
            }

            protected void resetEditorPages(Overview overview) {
            }

            protected Button newButton() {
                return DesignerPresenterTest.this.migrateButton;
            }
        });
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
    }

    @Test
    public void testSetup() {
        String id = "testId";
        this.presenter.setup(this.parameters, id, this.overview);
        ((Map)Mockito.verify(this.parameters, (VerificationMode)Mockito.times((int)1))).put("readonly", "false");
        ((DesignerEditorParametersPublisher)Mockito.verify((Object)this.designerEditorParametersPublisher, (VerificationMode)Mockito.times((int)1))).publish(this.parameters);
        ((DesignerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setup(id, this.parameters);
        Assert.assertEquals((long)1L, (long)this.parameters.size());
        Assert.assertTrue((boolean)this.parameters.containsKey("readonly"));
    }

    @Test
    public void testMakeMenuBar() {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)true)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Mockito.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addCopy((Path)Mockito.any(Path.class), (Validator)Mockito.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addRename((Command)Mockito.any(Command.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addDelete((Path)Mockito.any(Path.class), (Validator)Mockito.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
    }

    @Test
    public void testMakeMenuBarWithoutUpdateProjectPermission() {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)false)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Mockito.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addCopy((Path)Mockito.any(Path.class), (Validator)Mockito.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addRename((Command)Mockito.any(Command.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addDelete((Path)Mockito.any(Path.class), (Validator)Mockito.any(AssetUpdateValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
    }

    @Test
    public void testMigrateActionIsAddedToMenuBarWhenIntegrationIsPresent() {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)true)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Mockito.any());
        Optional<IntegrationHandler> optional = Optional.of(this.integrationHandler);
        Mockito.when((Object)this.integrationHandlerProvider.getIntegrationHandler()).thenReturn(optional);
        this.presenter.makeMenuBar();
        ((DesignerPresenter)Mockito.verify((Object)this.presenter)).newButton();
        ((Button)Mockito.verify((Object)this.migrateButton)).setSize(ButtonSize.SMALL);
        ((Button)Mockito.verify((Object)this.migrateButton)).setText(DesignerEditorConstants.INSTANCE.Migrate());
        ((Button)Mockito.verify((Object)this.migrateButton)).addClickHandler((ClickHandler)Mockito.any(ClickHandler.class));
    }

    @Test
    public void testMigrateActionIsNotAddedToMenuBarWhenIntegrationNotPresent() {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)true)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Mockito.any());
        Mockito.when((Object)this.integrationHandlerProvider.getIntegrationHandler()).thenReturn(Optional.empty());
        this.presenter.makeMenuBar();
        this.verifyMigrateActionWasNotAdded();
    }

    @Test
    public void testMigrateActionIsNotAddedToMenuBarWhenIntegrationIsPresentButProjectUpdateIsNotPermitted() {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)false)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Mockito.any());
        Optional<IntegrationHandler> optional = Optional.of(this.integrationHandler);
        Mockito.when((Object)this.integrationHandlerProvider.getIntegrationHandler()).thenReturn(optional);
        this.presenter.makeMenuBar();
        this.verifyMigrateActionWasNotAdded();
    }

    private void verifyMigrateActionWasNotAdded() {
        ((DesignerPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).newButton();
        ((Button)Mockito.verify((Object)this.migrateButton, (VerificationMode)Mockito.never())).setSize((ButtonSize)Mockito.any(ButtonSize.class));
        ((Button)Mockito.verify((Object)this.migrateButton, (VerificationMode)Mockito.never())).setText(Matchers.anyString());
        ((Button)Mockito.verify((Object)this.migrateButton, (VerificationMode)Mockito.never())).addClickHandler((ClickHandler)Mockito.any(ClickHandler.class));
    }

    @Test
    public void testMigrateWhenDirty() {
        this.testMigrate(true);
    }

    @Test
    public void testMigrateWhenNotDirty() {
        this.testMigrate(false);
    }

    private void testMigrate(boolean isDirty) {
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)true)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Mockito.any());
        ObservablePath currentPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)currentPath);
        Mockito.when((Object)this.view.canSaveDesignerModel()).thenReturn((Object)(!isDirty ? 1 : 0));
        Optional<IntegrationHandler> optional = Optional.of(this.integrationHandler);
        Mockito.when((Object)this.integrationHandlerProvider.getIntegrationHandler()).thenReturn(optional);
        this.presenter.makeMenuBar();
        ((Button)Mockito.verify((Object)this.migrateButton)).addClickHandler((ClickHandler)this.clickHandlerCaptor.capture());
        ((ClickHandler)this.clickHandlerCaptor.getValue()).onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((IntegrationHandler)Mockito.verify((Object)this.integrationHandler)).migrateFromJBPMDesignerToStunner((Path)Matchers.eq((Object)currentPath), (PlaceRequest)Matchers.eq((Object)this.place), Matchers.eq((boolean)isDirty), (ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
    }

    @Test
    public void testGetSaveAndRenameWhenAssetIsDirty() {
        String title = "title";
        String message = "message";
        Command doSaveAndRename = (Command)Mockito.mock(Command.class);
        Command doRename = (Command)Mockito.mock(Command.class);
        ((DesignerPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isDirty();
        ((DesignerPresenter)Mockito.doReturn((Object)"title").when((Object)this.presenter)).getPopupTitle();
        ((DesignerPresenter)Mockito.doReturn((Object)"message").when((Object)this.presenter)).getMessage();
        ((DesignerPresenter)Mockito.doReturn((Object)doSaveAndRename).when((Object)this.presenter)).doSaveAndRename();
        ((DesignerPresenter)Mockito.doReturn((Object)doRename).when((Object)this.presenter)).doRename();
        this.presenter.getSaveAndRename().execute();
        ((DesignerView)Mockito.verify((Object)this.view)).showYesNoCancelPopup("title", "message", doSaveAndRename, doRename);
    }

    @Test
    public void testGetSaveAndRenameWhenAssetIsNotDirty() {
        Command doRename = (Command)Mockito.mock(Command.class);
        ((DesignerPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isDirty();
        ((DesignerPresenter)Mockito.doReturn((Object)doRename).when((Object)this.presenter)).doRename();
        this.presenter.getSaveAndRename().execute();
        ((Command)Mockito.verify((Object)doRename)).execute();
    }

    @Test
    public void testIsDirtyWhenDesignerModelCanBeSaved() {
        ((DesignerView)Mockito.doReturn((Object)true).when((Object)this.view)).canSaveDesignerModel();
        Assert.assertFalse((boolean)this.presenter.isDirty());
    }

    @Test
    public void testIsDirtyWhenDesignerModelCannotBeSaved() {
        ((DesignerView)Mockito.doReturn((Object)false).when((Object)this.view)).canSaveDesignerModel();
        Assert.assertTrue((boolean)this.presenter.isDirty());
    }

    @Test
    public void testDoSaveAndRename() {
        Command command = (Command)Mockito.mock(Command.class);
        ((DesignerPresenter)Mockito.doReturn((Object)command).when((Object)this.presenter)).doRename();
        ((DesignerPresenter)Mockito.doNothing().when((Object)this.presenter)).save((Command)Mockito.any());
        this.presenter.doSaveAndRename().execute();
        ((DesignerPresenter)Mockito.verify((Object)this.presenter)).save(command);
    }

    @Test
    public void testDoRename() {
        ((DesignerPresenter)Mockito.doNothing().when((Object)this.presenter)).openRenamePopUp((ObservablePath)Mockito.any());
        this.presenter.doRename().execute();
        ((DesignerPresenter)Mockito.verify((Object)this.presenter)).openRenamePopUp((ObservablePath)Mockito.any());
    }

    @Test
    public void testOpenRenamePopUp() {
        ObservablePath observablePath = (ObservablePath)Mockito.mock(ObservablePath.class);
        CommandWithFileNameAndCommitMessage command = (CommandWithFileNameAndCommitMessage)Mockito.mock(CommandWithFileNameAndCommitMessage.class);
        ((DesignerPresenter)Mockito.doReturn((Object)command).when((Object)this.presenter)).makeRenameCommand();
        this.presenter.openRenamePopUp(observablePath);
        ((RenamePopUpPresenter)Mockito.verify((Object)this.renamePopUpPresenter)).show((Path)observablePath, (Validator)this.fileNameValidator, command);
    }

    @Test
    public void testMakeRenameCommand() {
        FileNameAndCommitMessage details = (FileNameAndCommitMessage)Mockito.mock(FileNameAndCommitMessage.class);
        ObservablePath observablePath = (ObservablePath)Mockito.mock(ObservablePath.class);
        RemoteCallback successCallback = (RemoteCallback)Mockito.mock(RemoteCallback.class);
        HasBusyIndicatorDefaultErrorCallback errorCallback = (HasBusyIndicatorDefaultErrorCallback)Mockito.mock(HasBusyIndicatorDefaultErrorCallback.class);
        String newFileName = "newFileName";
        String message = "message";
        ((FileNameAndCommitMessage)Mockito.doReturn((Object)"newFileName").when((Object)details)).getNewFileName();
        ((FileNameAndCommitMessage)Mockito.doReturn((Object)"message").when((Object)details)).getCommitMessage();
        ((VersionRecordManager)Mockito.doReturn((Object)observablePath).when((Object)this.versionRecordManager)).getPathToLatest();
        ((DesignerPresenter)Mockito.doReturn(this.renameServiceCaller).when((Object)this.presenter)).getRenameService();
        ((DesignerPresenter)Mockito.doReturn((Object)successCallback).when((Object)this.presenter)).getRenameSuccessCallback((RenamePopUpPresenter.View)Mockito.any());
        ((DesignerPresenter)Mockito.doReturn((Object)errorCallback).when((Object)this.presenter)).getRenameErrorCallback((RenamePopUpPresenter.View)Mockito.any());
        this.presenter.makeRenameCommand().execute((Object)details);
        ((RenameService)Mockito.verify((Object)this.renameService)).rename((Path)observablePath, "newFileName", "message");
    }
}

