/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client;

import java.util.HashMap;
import java.util.Map;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jbpm.designer.client.DesignerPresenter;
import org.jbpm.designer.client.DesignerView;
import org.jbpm.designer.client.parameters.DesignerEditorParametersPublisher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilderImpl;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=MockitoJUnitRunner.class)
public class DesignerPresenterTest {
    @Mock
    protected BasicFileMenuBuilder menuBuilder;
    @Mock
    protected VersionRecordManager versionRecordManager;
    @Spy
    @InjectMocks
    protected FileMenuBuilderImpl fileMenuBuilder;
    @Mock
    protected ProjectController projectController;
    @Mock
    protected ProjectContext workbenchContext;
    @Mock
    private DesignerView view;
    @Mock
    private Overview overview;
    @Mock
    private DesignerEditorParametersPublisher designerEditorParametersPublisher;
    @Spy
    private Map<String, String> parameters = new HashMap<String, String>();
    private DesignerPresenter presenter;

    @Before
    public void setup() {
        this.presenter = (DesignerPresenter)Mockito.spy((Object)new DesignerPresenter(this.view){
            {
                this.fileMenuBuilder = DesignerPresenterTest.this.fileMenuBuilder;
                this.projectController = DesignerPresenterTest.this.projectController;
                this.workbenchContext = DesignerPresenterTest.this.workbenchContext;
                this.versionRecordManager = DesignerPresenterTest.this.versionRecordManager;
                this.designerEditorParametersPublisher = DesignerPresenterTest.this.designerEditorParametersPublisher;
            }

            protected void resetEditorPages(Overview overview) {
            }
        });
    }

    @Test
    public void testSetup() {
        String id = "testId";
        this.presenter.setup(this.parameters, id, this.overview);
        ((Map)Mockito.verify(this.parameters, (VerificationMode)Mockito.times((int)1))).put("readonly", "false");
        ((DesignerEditorParametersPublisher)Mockito.verify((Object)this.designerEditorParametersPublisher, (VerificationMode)Mockito.times((int)1))).publish(this.parameters);
        ((DesignerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setup(id, this.parameters);
        Assert.assertEquals((long)1L, (long)this.parameters.size());
        Assert.assertTrue((boolean)this.parameters.containsKey("readonly"));
    }

    @Test
    public void testMakeMenuBar() {
        ((ProjectContext)Mockito.doReturn((Object)Mockito.mock(Project.class)).when((Object)this.workbenchContext)).getActiveProject();
        ((ProjectController)Mockito.doReturn((Object)true).when((Object)this.projectController)).canUpdateProject((Project)Mockito.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addCopy((Path)Mockito.any(Path.class), (Validator)Mockito.any(DefaultFileNameValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addRename((Path)Mockito.any(Path.class), (Validator)Mockito.any(DefaultFileNameValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder)).addDelete((Path)Mockito.any(Path.class));
    }

    @Test
    public void testMakeMenuBarWithoutUpdateProjectPermission() {
        ((ProjectContext)Mockito.doReturn((Object)Mockito.mock(Project.class)).when((Object)this.workbenchContext)).getActiveProject();
        ((ProjectController)Mockito.doReturn((Object)false).when((Object)this.projectController)).canUpdateProject((Project)Mockito.any());
        this.presenter.makeMenuBar();
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addCopy((Path)Mockito.any(Path.class), (Validator)Mockito.any(DefaultFileNameValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addRename((Path)Mockito.any(Path.class), (Validator)Mockito.any(DefaultFileNameValidator.class));
        ((FileMenuBuilderImpl)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addDelete((Path)Mockito.any(Path.class));
    }
}

