/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.util;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import java.util.List;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.ValueListBox;
import org.jbpm.designer.client.util.ComboBoxView;

public class ComboBoxViewImpl
implements ComboBoxView {
    protected ComboBoxView.ComboBoxPresenter presenter;
    protected ComboBoxView.ModelPresenter modelPresenter;
    protected ValueListBox<String> listBox;
    protected TextBox textBox;
    protected boolean listBoxHasFocus = false;

    @Override
    public void init(final ComboBoxView.ComboBoxPresenter presenter, ComboBoxView.ModelPresenter modelPresenter, ValueListBox<String> listBox, TextBox textBox, String placeholder) {
        this.presenter = presenter;
        this.modelPresenter = modelPresenter;
        this.listBox = listBox;
        this.textBox = textBox;
        this.textBox.setPlaceholder(placeholder);
        textBox.setVisible(false);
        listBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> valueChangeEvent) {
                presenter.listBoxValueChanged((String)valueChangeEvent.getValue());
            }
        });
        listBox.addDomHandler((EventHandler)new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent mouseDownEvent) {
                if (!ComboBoxViewImpl.this.listBoxHasFocus) {
                    ComboBoxViewImpl.this.listBoxHasFocus = true;
                    ComboBoxViewImpl.this.listBoxGotFocus();
                }
            }
        }, MouseDownEvent.getType());
        listBox.addDomHandler((EventHandler)new BlurHandler(){

            public void onBlur(BlurEvent blurEvent) {
                ComboBoxViewImpl.this.listBoxHasFocus = false;
            }
        }, BlurEvent.getType());
        textBox.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent focusEvent) {
                ComboBoxViewImpl.this.textBoxGotFocus();
            }
        });
        textBox.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent blurEvent) {
                ComboBoxViewImpl.this.textBoxLostFocus();
            }
        });
    }

    @Override
    public String getModelValue() {
        return this.modelPresenter.getModelValue(this.listBox);
    }

    @Override
    public void setTextBoxModelValue(String value) {
        this.modelPresenter.setTextBoxModelValue(this.textBox, value);
    }

    @Override
    public void setListBoxModelValue(String value) {
        this.modelPresenter.setListBoxModelValue(this.listBox, value);
    }

    @Override
    public String getListBoxValue() {
        return (String)this.listBox.getValue();
    }

    @Override
    public void setListBoxValue(String value) {
        this.listBox.setValue((Object)value);
    }

    @Override
    public void setTextBoxValue(String value) {
        this.textBox.setValue((Object)value);
    }

    @Override
    public void setTextBoxVisible(boolean visible) {
        this.textBox.setVisible(visible);
    }

    @Override
    public void setListBoxVisible(boolean visible) {
        this.listBox.setVisible(visible);
    }

    @Override
    public void setTextBoxFocus(boolean focus) {
        this.textBox.setFocus(focus);
    }

    @Override
    public void textBoxGotFocus() {
        this.presenter.setCurrentTextValue(this.textBox.getValue());
    }

    @Override
    public void textBoxLostFocus() {
        this.presenter.textBoxValueChanged(this.textBox.getValue());
    }

    @Override
    public void listBoxGotFocus() {
        this.presenter.updateListBoxValues((String)this.listBox.getValue());
    }

    @Override
    public void setAcceptableValues(List<String> acceptableValues) {
        this.listBox.setAcceptableValues(acceptableValues);
    }

    @Override
    public String getValue() {
        if (this.textBox.isVisible()) {
            return this.textBox.getValue();
        }
        return (String)this.listBox.getValue();
    }
}

