/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.handlers;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jbpm.designer.client.resources.DesignerEditorResources;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.type.Bpmn2Type;
import org.jbpm.designer.service.DesignerAssetService;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewProcessHandler
extends DefaultNewResourceHandler {
    private Caller<DesignerAssetService> designerAssetService;
    private Bpmn2Type resourceType;

    public NewProcessHandler() {
    }

    @Inject
    public NewProcessHandler(Caller<DesignerAssetService> designerAssetService, PlaceManager placeManager, Bpmn2Type resourceType) {
        this.designerAssetService = designerAssetService;
        this.placeManager = placeManager;
        this.resourceType = resourceType;
    }

    protected NewProcessHandler(Caller<DesignerAssetService> designerAssetService, PlaceManager placeManager, Bpmn2Type resourceType, Event<NewResourceSuccessEvent> newResourceSuccessEvent) {
        this(designerAssetService, placeManager, resourceType);
        this.newResourceSuccessEvent = newResourceSuccessEvent;
    }

    public String getDescription() {
        return DesignerEditorConstants.INSTANCE.businessProcess();
    }

    public IsWidget getIcon() {
        return new Image(DesignerEditorResources.INSTANCE.images().typeForm());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    public void create(Package pkg, String baseFileName, NewResourcePresenter presenter) {
        ((DesignerAssetService)this.designerAssetService.call(path -> {
            presenter.complete();
            this.notifySuccess();
            this.newResourceSuccessEvent.fire((Object)new NewResourceSuccessEvent(path));
            this.placeManager.goTo(path);
        }, (ErrorCallback)new DefaultErrorCallback())).createProcess(pkg.getPackageMainResourcesPath(), this.buildFileName(baseFileName, (ResourceTypeDefinition)this.resourceType));
    }

    public int order() {
        return -30;
    }

    public boolean isProjectAsset() {
        return false;
    }
}

