/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.shared;

import com.google.gwt.junit.GWTMockUtilities;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.shared.Assignment;
import org.jbpm.designer.client.shared.util.StringUtils;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class AssignmentBaseTest {
    protected StringUtils utils = (StringUtils)Mockito.spy(StringUtils.class);

    public void setUp() throws Exception {
        GWTMockUtilities.disarm();
        Answer answer = invocation -> invocation.getMethod().getName();
        DesignerEditorConstants designerEditorConstants = (DesignerEditorConstants)Mockito.mock(DesignerEditorConstants.class, (Answer)answer);
        this.setFinalStaticField(DesignerEditorConstants.class.getDeclaredField("INSTANCE"), designerEditorConstants);
        Mockito.when((Object)this.utils.urlDecode((String)Mockito.any())).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            return this.urlDecode((String)args[0]);
        });
        Mockito.when((Object)this.utils.urlEncode((String)Mockito.any())).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            return this.urlEncode((String)args[0]);
        });
        Assignment.setStringUtils((StringUtils)this.utils);
    }

    public void tearDown() {
        GWTMockUtilities.restore();
    }

    public String urlEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public String urlDecode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    private void setFinalStaticField(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }
}

