/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.util;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.ValueListBox;
import org.jbpm.designer.client.util.ComboBoxView;
import org.jbpm.designer.client.util.ComboBoxViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;

@RunWith(value=GwtMockitoTestRunner.class)
public class ComboBoxViewImplTest {
    private static final String LB_VALUE = "LIST_BOX_VALUE";
    private static final String TB_VALUE = "TEXT_BOX_VALUE";
    @Spy
    ComboBoxViewImpl view;
    @Mock
    ComboBoxView.ComboBoxPresenter presenter;
    @Mock
    ComboBoxView.ModelPresenter modelPresenter;
    @Mock
    ValueListBox valueListBox;
    @Mock
    TextBox textBox;

    @Before
    public void init() throws Exception {
        Mockito.when((Object)this.valueListBox.getValue()).thenReturn((Object)LB_VALUE);
        Mockito.when((Object)this.textBox.getValue()).thenReturn((Object)TB_VALUE);
    }

    @Test
    public void testViewInit() throws Exception {
        ArgumentCaptor mousDownCaptor = ArgumentCaptor.forClass(MouseDownHandler.class);
        ArgumentCaptor blurCaptor = ArgumentCaptor.forClass(BlurHandler.class);
        ArgumentCaptor focusCaptor = ArgumentCaptor.forClass(FocusHandler.class);
        this.view.init(this.presenter, this.modelPresenter, this.valueListBox, this.textBox, "placeholder");
        ((ValueListBox)Mockito.verify((Object)this.valueListBox)).addDomHandler((EventHandler)mousDownCaptor.capture(), (DomEvent.Type)Matchers.eq((Object)MouseDownEvent.getType()));
        ((MouseDownHandler)mousDownCaptor.getValue()).onMouseDown(null);
        Assert.assertEquals((Object)true, (Object)this.view.listBoxHasFocus);
        ((ComboBoxView.ComboBoxPresenter)Mockito.verify((Object)this.presenter)).updateListBoxValues(LB_VALUE);
        ((ValueListBox)Mockito.verify((Object)this.valueListBox)).addDomHandler((EventHandler)blurCaptor.capture(), (DomEvent.Type)Matchers.eq((Object)BlurEvent.getType()));
        ((BlurHandler)blurCaptor.getValue()).onBlur(null);
        Assert.assertEquals((Object)false, (Object)this.view.listBoxHasFocus);
        ((TextBox)Mockito.verify((Object)this.textBox)).addFocusHandler((FocusHandler)focusCaptor.capture());
        ((FocusHandler)focusCaptor.getValue()).onFocus(null);
        ((ComboBoxView.ComboBoxPresenter)Mockito.verify((Object)this.presenter)).setCurrentTextValue(TB_VALUE);
        ((TextBox)Mockito.verify((Object)this.textBox)).addBlurHandler((BlurHandler)blurCaptor.capture());
        ((BlurHandler)blurCaptor.getValue()).onBlur(null);
        ((ComboBoxView.ComboBoxPresenter)Mockito.verify((Object)this.presenter)).textBoxValueChanged(TB_VALUE);
    }
}

