/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.parameters;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.designer.client.parameters.DesignerEditorParametersPublisher;
import org.jbpm.designer.client.parameters.DesignerEditorParametersPublisherView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class DesignerEditorParametersPublisherTest {
    @Mock
    private DesignerEditorParametersPublisherView view;
    @Mock
    private SessionInfo sessionInfo;
    @Spy
    @InjectMocks
    private DesignerEditorParametersPublisher publisher = new DesignerEditorParametersPublisher();
    private Map<String, String> parameters;

    @Before
    public void clearParameters() {
        Mockito.when((Object)this.sessionInfo.getId()).thenReturn((Object)"12345");
        this.parameters = new HashMap<String, String>();
    }

    @Test
    public void testPublish() {
        this.publisher.publish(this.parameters);
        ((DesignerEditorParametersPublisher)Mockito.verify((Object)this.publisher, (VerificationMode)Mockito.times((int)1))).publishProcessSources(this.parameters);
        ((DesignerEditorParametersPublisher)Mockito.verify((Object)this.publisher, (VerificationMode)Mockito.times((int)1))).publishActiveNodes(this.parameters);
        ((DesignerEditorParametersPublisher)Mockito.verify((Object)this.publisher, (VerificationMode)Mockito.times((int)1))).publishCompletedNodes(this.parameters);
        ((DesignerEditorParametersPublisher)Mockito.verify((Object)this.publisher, (VerificationMode)Mockito.times((int)1))).putTimeStampToParameters(this.parameters);
        ((DesignerEditorParametersPublisher)Mockito.verify((Object)this.publisher, (VerificationMode)Mockito.times((int)1))).putSessionIdToParameters(this.parameters);
        Assert.assertEquals((long)2L, (long)this.parameters.size());
        Assert.assertTrue((boolean)this.parameters.containsKey("ts"));
        Assert.assertTrue((boolean)this.parameters.containsKey("sessionId"));
    }

    @Test
    public void testProcessSources() {
        this.parameters.put("processsource", "value");
        this.publisher.publishProcessSources(this.parameters);
        ((DesignerEditorParametersPublisherView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).publishProcessSourcesInfo("value");
        Assert.assertEquals((long)1L, (long)this.parameters.size());
        Assert.assertEquals((Object)"true", (Object)this.parameters.get("instanceviewmode"));
    }

    @Test
    public void testProcessSourcesEmpty() {
        this.parameters.put("processsource", "");
        this.publisher.publishProcessSources(this.parameters);
        ((DesignerEditorParametersPublisherView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).publishProcessSourcesInfo(Mockito.anyString());
        Assert.assertEquals((long)1L, (long)this.parameters.size());
        Assert.assertEquals((Object)"false", (Object)this.parameters.get("instanceviewmode"));
    }

    @Test
    public void testProcessSourcesNull() {
        this.parameters.put("processsource", null);
        this.publisher.publishProcessSources(this.parameters);
        ((DesignerEditorParametersPublisherView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).publishProcessSourcesInfo(Mockito.anyString());
        Assert.assertEquals((long)1L, (long)this.parameters.size());
        Assert.assertEquals((Object)"false", (Object)this.parameters.get("instanceviewmode"));
    }

    @Test
    public void testActiveNodes() {
        this.parameters.put("activenodes", "value");
        this.publisher.publishActiveNodes(this.parameters);
        ((DesignerEditorParametersPublisherView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).publishActiveNodesInfo("value");
        Assert.assertEquals((long)0L, (long)this.parameters.size());
    }

    @Test
    public void testActiveNodesEmpty() {
        this.parameters.put("activenodes", "");
        this.publisher.publishActiveNodes(this.parameters);
        ((DesignerEditorParametersPublisherView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).publishActiveNodesInfo(Mockito.anyString());
        Assert.assertEquals((long)0L, (long)this.parameters.size());
    }

    @Test
    public void testActiveNodesNull() {
        this.parameters.put("activenodes", null);
        this.publisher.publishActiveNodes(this.parameters);
        ((DesignerEditorParametersPublisherView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).publishActiveNodesInfo(Mockito.anyString());
        Assert.assertEquals((long)0L, (long)this.parameters.size());
    }

    @Test
    public void testCompletedNodes() {
        this.parameters.put("completednodes", "value");
        this.publisher.publishCompletedNodes(this.parameters);
        ((DesignerEditorParametersPublisherView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).publishCompletedNodesInfo("value");
        Assert.assertEquals((long)0L, (long)this.parameters.size());
    }

    @Test
    public void testCompletedNodesEmpty() {
        this.parameters.put("completednodes", "");
        this.publisher.publishCompletedNodes(this.parameters);
        ((DesignerEditorParametersPublisherView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).publishCompletedNodesInfo(Mockito.anyString());
        Assert.assertEquals((long)0L, (long)this.parameters.size());
    }

    @Test
    public void testCompletedNodesNull() {
        this.parameters.put("completednodes", null);
        this.publisher.publishCompletedNodes(this.parameters);
        ((DesignerEditorParametersPublisherView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).publishCompletedNodesInfo(Mockito.anyString());
        Assert.assertEquals((long)0L, (long)this.parameters.size());
    }

    @Test
    public void testPutSessionId() {
        Assert.assertEquals((long)0L, (long)this.parameters.size());
        this.publisher.putSessionIdToParameters(this.parameters);
        Assert.assertEquals((long)1L, (long)this.parameters.size());
        Assert.assertEquals((Object)"12345", (Object)this.parameters.get("sessionId"));
    }

    @Test
    public void testPutTimeStamp() {
        Assert.assertEquals((long)0L, (long)this.parameters.size());
        this.publisher.putTimeStampToParameters(this.parameters);
        Assert.assertEquals((long)1L, (long)this.parameters.size());
        Assert.assertTrue((boolean)this.parameters.containsKey("ts"));
        Assert.assertNotNull((Object)this.parameters.get("ts"));
    }
}

