/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.shared;

import com.google.gwt.junit.GWTMockUtilities;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.shared.util.StringUtils;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;

public class AssignmentBaseTest {
    public void setUp() throws Exception {
        GWTMockUtilities.disarm();
        Answer answer = new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return invocation.getMethod().getName();
            }
        };
        DesignerEditorConstants designerEditorConstants = (DesignerEditorConstants)PowerMockito.mock(DesignerEditorConstants.class, (Answer)answer);
        this.setFinalStaticField(DesignerEditorConstants.class.getDeclaredField("INSTANCE"), designerEditorConstants);
        PowerMockito.mockStatic(StringUtils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)StringUtils.urlEncode((String)Mockito.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return AssignmentBaseTest.this.urlEncode((String)args[0]);
            }
        });
        PowerMockito.when((Object)StringUtils.urlDecode((String)Mockito.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return AssignmentBaseTest.this.urlDecode((String)args[0]);
            }
        });
        PowerMockito.when((Object)StringUtils.createQuotedConstant((String)Mockito.anyString())).thenCallRealMethod();
        PowerMockito.when((Object)StringUtils.createUnquotedConstant((String)Mockito.anyString())).thenCallRealMethod();
    }

    public void tearDown() {
        GWTMockUtilities.restore();
    }

    public String urlEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public String urlDecode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    private void setFinalStaticField(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }
}

