/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.service.impl;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jbpm.document.Document;
import org.jbpm.document.service.DocumentStorageService;
import org.jbpm.document.service.impl.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStorageServiceImpl
implements DocumentStorageService {
    private Logger log = LoggerFactory.getLogger(DocumentStorageServiceImpl.class);
    private String storagePath = ".docs";

    @Override
    public Document saveDocument(Document document, byte[] content) {
        if (document == null || !StringUtils.isEmpty((String)document.getIdentifier())) {
            return document;
        }
        String destinationPath = this.generateUniquePath(document.getName());
        File destination = new File(destinationPath);
        try {
            FileUtils.writeByteArrayToFile((File)destination, (byte[])content);
            document.setIdentifier(Base64.encodeBase64String((byte[])destinationPath.getBytes()));
            String link = "Controller?_fb=fdch&_fp=download&content=" + document.getIdentifier();
            document.setLink(link);
        }
        catch (IOException e) {
            this.log.error("Error writing file {}: {}", (Object)document.getName(), (Object)e);
        }
        return document;
    }

    @Override
    public Document getDocument(String id) {
        File file = new File(new String(Base64.decodeBase64((String)id)));
        if (file.exists()) {
            try {
                DocumentImpl doc = new DocumentImpl(id, file.getName(), file.length(), new Date(file.lastModified()));
                doc.setContent(FileUtils.readFileToByteArray((File)file));
                return doc;
            }
            catch (IOException e) {
                this.log.error("Error loading document '{}': {}", (Object)id, (Object)e);
            }
        }
        return null;
    }

    @Override
    public boolean deleteDocument(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return true;
        }
        return this.deleteDocument(this.getDocument(id));
    }

    @Override
    public boolean deleteDocument(Document doc) {
        if (doc != null) {
            return this.deleteFile(this.getDocumentContent(doc));
        }
        return true;
    }

    public File getDocumentContent(Document doc) {
        if (doc != null) {
            return new File(doc.getIdentifier());
        }
        return null;
    }

    protected boolean deleteFile(File file) {
        try {
            if (file != null) {
                String[] list;
                if (file.isFile()) {
                    file.delete();
                    return this.deleteFile(file.getParentFile());
                }
                if (!(file.getName().equals(this.storagePath) || (list = file.list()) != null && list.length != 0)) {
                    file.delete();
                    return this.deleteFile(file.getParentFile());
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error deleting file: ", (Throwable)e);
            return false;
        }
        return true;
    }

    protected String generateUniquePath(String fileName) {
        String destinationPath = this.storagePath + "/";
        destinationPath = destinationPath + UUID.randomUUID().toString();
        if (!(destinationPath = destinationPath.replaceAll("-", "/")).endsWith("/")) {
            destinationPath = destinationPath + "/";
        }
        return destinationPath + "/" + fileName;
    }
}

