/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.service.impl;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.document.Document;
import org.jbpm.document.service.DocumentStorageService;
import org.jbpm.document.service.impl.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStorageServiceImpl
implements DocumentStorageService {
    private Logger log = LoggerFactory.getLogger(DocumentStorageServiceImpl.class);
    private String storagePath = ".docs";

    @Override
    public Document buildDocument(String name, long size, Date lastModified, Map<String, String> params) {
        String identifier = this.generateUniquePath();
        String appURL = params.get("app.url");
        if (appURL == null) {
            appURL = "";
        }
        if (!appURL.isEmpty() && !appURL.endsWith("/")) {
            appURL = appURL + "/";
        }
        String link = appURL + "Controller?_fb=fdch&_fp=download&content=" + identifier;
        return new DocumentImpl(identifier, name, size, lastModified, link);
    }

    @Override
    public Document saveDocument(Document document, byte[] content) {
        if (document == null || StringUtils.isEmpty((CharSequence)document.getIdentifier())) {
            return null;
        }
        File destination = this.getFileByPath(document.getIdentifier() + "/" + document.getName());
        try {
            FileUtils.writeByteArrayToFile((File)destination, (byte[])content);
        }
        catch (IOException e) {
            this.log.error("Error writing file {}: {}", (Object)document.getName(), (Object)e);
        }
        return document;
    }

    @Override
    public Document getDocument(String id) {
        File file = this.getFileByPath(id);
        if (file.exists() && !file.isFile() && !ArrayUtils.isEmpty((Object[])file.listFiles())) {
            try {
                File destination = file.listFiles()[0];
                DocumentImpl doc = new DocumentImpl(id, destination.getName(), destination.length(), new Date(destination.lastModified()));
                doc.setContent(FileUtils.readFileToByteArray((File)destination));
                return doc;
            }
            catch (IOException e) {
                this.log.error("Error loading document '{}': {}", (Object)id, (Object)e);
            }
        }
        return null;
    }

    @Override
    public boolean deleteDocument(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return true;
        }
        return this.deleteDocument(this.getDocument(id));
    }

    @Override
    public boolean deleteDocument(Document doc) {
        if (doc != null) {
            File rootDoc = this.getDocumentContent(doc);
            if (!ArrayUtils.isEmpty((Object[])rootDoc.listFiles())) {
                return this.deleteFile(rootDoc.listFiles()[0]);
            }
            return this.deleteFile(rootDoc);
        }
        return true;
    }

    public File getDocumentContent(Document doc) {
        if (doc != null) {
            return this.getFileByPath(doc.getIdentifier());
        }
        return null;
    }

    protected boolean deleteFile(File file) {
        try {
            if (file != null) {
                String[] list;
                if (file.isFile()) {
                    file.delete();
                    return this.deleteFile(file.getParentFile());
                }
                if (!(file.getName().equals(this.storagePath) || (list = file.list()) != null && list.length != 0)) {
                    file.delete();
                    return this.deleteFile(file.getParentFile());
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error deleting file: ", (Throwable)e);
            return false;
        }
        return true;
    }

    protected String generateUniquePath() {
        String destinationPath;
        File parent;
        while ((parent = this.getFileByPath(destinationPath = UUID.randomUUID().toString())).exists()) {
        }
        return destinationPath;
    }

    protected File getFileByPath(String path) {
        return new File(this.storagePath + "/" + path);
    }
}

