/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.service.impl;

import java.io.File;
import java.nio.file.Files;
import java.util.Date;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.document.service.impl.DocumentImpl;
import org.junit.Assert;
import org.junit.Test;

public class DocumentImplTest {
    private static final String ID = "1234567890";
    private static final String FILENAME = "Document_Name";
    private static final String EXTENSION = ".txt";
    private static final String NAME = "Document_Name.txt";
    private static final Long SIZE = 1024L;
    private static final Date LAST_MODIFIED = new Date();
    private static final String LINK = "downloadLink";
    private static final String CONTENT = "test content";

    @Test
    public void testDefaultConstructor() {
        DocumentImpl document = new DocumentImpl();
        Assertions.assertThat((String)document.getIdentifier()).isNotNull();
    }

    @Test
    public void testConstructorWithoutIdentifier() {
        DocumentImpl document = new DocumentImpl(NAME, SIZE.longValue(), LAST_MODIFIED);
        Assertions.assertThat((String)document.getIdentifier()).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)document.getName()).isNotNull()).isEqualTo((Object)NAME);
        Assertions.assertThat((long)document.getSize()).isEqualTo((Object)SIZE);
        Assertions.assertThat((Date)document.getLastModified()).isEqualTo((Object)LAST_MODIFIED);
    }

    @Test
    public void testConstructorWithIdentifier() {
        DocumentImpl document = new DocumentImpl(ID, NAME, SIZE.longValue(), LAST_MODIFIED);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)document.getIdentifier()).isNotNull()).isEqualTo((Object)ID);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)document.getName()).isNotNull()).isEqualTo((Object)NAME);
        Assertions.assertThat((long)document.getSize()).isEqualTo((Object)SIZE);
        Assertions.assertThat((Date)document.getLastModified()).isEqualTo((Object)LAST_MODIFIED);
    }

    @Test
    public void testFullConstructor() {
        DocumentImpl document = new DocumentImpl(ID, NAME, SIZE.longValue(), LAST_MODIFIED, LINK);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)document.getIdentifier()).isNotNull()).isEqualTo((Object)ID);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)document.getName()).isNotNull()).isEqualTo((Object)NAME);
        Assertions.assertThat((long)document.getSize()).isEqualTo((Object)SIZE);
        Assertions.assertThat((Date)document.getLastModified()).isEqualTo((Object)LAST_MODIFIED);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)document.getLink()).isNotNull()).isNotEmpty().isEqualTo((Object)LINK);
    }

    @Test
    public void testToStringRepresentation() {
        DocumentImpl document = new DocumentImpl();
        try {
            Assert.assertNotNull((Object)document.toString());
        }
        catch (Throwable th) {
            Assert.fail((String)("toString method must not fire any exception: " + th.getMessage()));
        }
    }

    @Test
    public void testToFile() throws Exception {
        DocumentImpl document = new DocumentImpl(ID, NAME, SIZE.longValue(), LAST_MODIFIED, LINK);
        document.setContent(CONTENT.getBytes());
        File file = document.toFile();
        Assert.assertNotNull((Object)file);
        Assert.assertNotNull((Object)file.getName());
        Assert.assertTrue((boolean)file.getName().contains(FILENAME));
        Assert.assertTrue((boolean)file.getName().contains(EXTENSION));
        String fileContent = new String(Files.readAllBytes(file.toPath()));
        Assert.assertNotNull((Object)fileContent);
        Assert.assertEquals((Object)fileContent, (Object)CONTENT);
    }
}

