/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.marshalling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jbpm.document.Document;
import org.jbpm.document.Documents;
import org.jbpm.document.marshalling.DocumentMarshallingStrategy;
import org.jbpm.document.marshalling.DocumentsMarshallingStrategy;
import org.jbpm.document.service.impl.DocumentImpl;
import org.junit.Assert;
import org.junit.Test;

public class DocumentsMarshallingStrategyTest {
    private DocumentsMarshallingStrategy docsMarshallingStrategy = new DocumentsMarshallingStrategy(new DocumentMarshallingStrategy());

    @Test
    public void testMarshallUnmarshall() throws IOException, ClassNotFoundException {
        List<Document> documents = this.getDocuments();
        Documents docs = new Documents(documents);
        byte[] marshalledDocs = this.docsMarshallingStrategy.marshal(null, null, (Object)docs);
        Documents unmarshalledDocs = (Documents)this.docsMarshallingStrategy.unmarshal(null, null, marshalledDocs, this.getClass().getClassLoader());
        Assert.assertEquals((long)docs.getDocuments().size(), (long)unmarshalledDocs.getDocuments().size());
        List unmarshalledDocumentsList = unmarshalledDocs.getDocuments();
        Assert.assertEquals((long)documents.size(), (long)unmarshalledDocumentsList.size());
        Assert.assertEquals((Object)((Document)unmarshalledDocumentsList.get(0)).getName(), (Object)((Document)docs.getDocuments().get(0)).getName());
        Assert.assertEquals((Object)((Document)unmarshalledDocumentsList.get(0)).getLink(), (Object)((Document)docs.getDocuments().get(0)).getLink());
        Assert.assertEquals((Object)((Document)unmarshalledDocumentsList.get(1)).getName(), (Object)((Document)docs.getDocuments().get(1)).getName());
        Assert.assertEquals((Object)((Document)unmarshalledDocumentsList.get(1)).getLink(), (Object)((Document)docs.getDocuments().get(1)).getLink());
    }

    @Test
    public void testSingleDocMarshallUnmarshall() throws IOException, ClassNotFoundException {
        DocumentMarshallingStrategy docMarshallingStrategy = new DocumentMarshallingStrategy();
        Document document = this.getDocument("docOne");
        byte[] marshalledDocument = docMarshallingStrategy.marshal(null, null, (Object)document);
        Document unmarshalledDocument = (Document)docMarshallingStrategy.unmarshal(null, null, marshalledDocument, this.getClass().getClassLoader());
        Assert.assertEquals((Object)document.getName(), (Object)unmarshalledDocument.getName());
        Assert.assertEquals((Object)document.getLink(), (Object)unmarshalledDocument.getLink());
    }

    @Test
    public void testNoDocumentsMarshallUnmarshall() throws IOException, ClassNotFoundException {
        Documents docs = new Documents();
        byte[] marshalledDocuments = this.docsMarshallingStrategy.marshal(null, null, (Object)docs);
        Documents unmarshalledDocuments = (Documents)this.docsMarshallingStrategy.unmarshal(null, null, marshalledDocuments, this.getClass().getClassLoader());
        Assert.assertEquals((long)docs.getDocuments().size(), (long)unmarshalledDocuments.getDocuments().size());
    }

    private Document getDocument(String documentName) {
        DocumentImpl documentOne = new DocumentImpl();
        documentOne.setIdentifier(documentName);
        documentOne.setLastModified(new Date());
        documentOne.setLink("http://" + documentName);
        documentOne.setName(documentName + " Name");
        documentOne.setSize(1L);
        documentOne.setContent(documentName.getBytes());
        return documentOne;
    }

    private List<Document> getDocuments() {
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(this.getDocument("documentOne"));
        documents.add(this.getDocument("documentTwo"));
        return documents;
    }
}

