/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.audit;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jbpm.document.Documents;
import org.jbpm.document.audit.DocumentCollectionVariableIndexer;
import org.jbpm.document.service.impl.DocumentCollectionImpl;
import org.jbpm.document.service.impl.DocumentImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;

public class DocumentCollectionVariableIndexerTest {
    private static final String VARIABLE_NAME = "dox";
    private static final String DOC_1 = "doc_1";
    private static final String DOC_2 = "doc_2";
    private static final String DOC_3 = "doc_3";
    private DocumentCollectionVariableIndexer indexer = new DocumentCollectionVariableIndexer();

    @Test
    public void testAccept() {
        Assert.assertFalse((boolean)this.indexer.accept((Object)"A String"));
        Assert.assertFalse((boolean)this.indexer.accept((Object)57));
        Assert.assertFalse((boolean)this.indexer.accept((Object)Boolean.FALSE));
        Assert.assertFalse((boolean)this.indexer.accept(null));
        Assert.assertTrue((boolean)this.indexer.accept((Object)new Documents()));
    }

    @Test
    public void testIndexEmpty() {
        Assertions.assertThat((List)this.indexer.index(VARIABLE_NAME, (Object)new Documents())).isEmpty();
    }

    @Test
    public void testIndex() {
        DocumentImpl doc1 = new DocumentImpl(DOC_1, DOC_1, 1024L, new Date());
        DocumentImpl doc2 = new DocumentImpl(DOC_2, DOC_3, 1024L, new Date());
        DocumentImpl doc3 = new DocumentImpl(DOC_3, DOC_3, 1024L, new Date());
        List indexed = this.indexer.index(VARIABLE_NAME, (Object)new DocumentCollectionImpl(Arrays.asList(doc1, doc2, doc3)));
        Assertions.assertThat((List)indexed).hasSize(3);
        this.testDocument(0, 3, (VariableInstanceLog)indexed.get(0), doc1);
        this.testDocument(1, 3, (VariableInstanceLog)indexed.get(1), doc2);
        this.testDocument(2, 3, (VariableInstanceLog)indexed.get(2), doc3);
    }

    private void testDocument(int index, int max, VariableInstanceLog log, DocumentImpl document) {
        ((ObjectAssert)Assertions.assertThat((Object)log).hasFieldOrPropertyWithValue("variableId", (Object)("dox (" + (index + 1) + "/" + max + ")"))).hasFieldOrPropertyWithValue("value", (Object)document.toString());
    }
}

