/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.service;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jbpm.document.Document;
import org.jbpm.document.service.DocumentStorageService;
import org.jbpm.document.service.DocumentStorageServiceProvider;
import org.jbpm.document.service.impl.DocumentStorageServiceImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DocumentStorageServiceImplTest {
    private static final String STORAGE_PATH_TEST = "target/docs";
    private DocumentStorageService documentStorageService;

    @Parameterized.Parameters(name="{index}: impl={0}")
    public static Iterable<Object[]> data() {
        System.setProperty("org.jbpm.document.storage", STORAGE_PATH_TEST);
        return Arrays.asList({new DocumentStorageServiceImpl()}, {DocumentStorageServiceProvider.get().getStorageService()});
    }

    public DocumentStorageServiceImplTest(DocumentStorageService documentStorageService) {
        this.documentStorageService = documentStorageService;
    }

    @AfterClass
    public static void cleanupOnce() {
        System.clearProperty("org.jbpm.document.storage");
    }

    @Before
    public void setup() {
        File storagePath = new File(STORAGE_PATH_TEST);
        this.deleteFolder(storagePath);
    }

    protected void deleteFolder(File path) {
        File[] directories = path.listFiles();
        if (directories != null) {
            for (File file : directories) {
                if (file.isDirectory()) {
                    this.deleteFolder(file);
                }
                file.delete();
            }
        }
    }

    @Test
    public void testSaveAndGetDocument() {
        byte[] content = "document content".getBytes();
        Document document = this.documentStorageService.buildDocument("mydoc", (long)content.length, new Date(), new HashMap());
        Assert.assertNotNull((Object)document.getIdentifier());
        this.documentStorageService.saveDocument(document, content);
        Document fromStorage = this.documentStorageService.getDocument(document.getIdentifier());
        Assert.assertNotNull((Object)fromStorage);
        Assert.assertEquals((Object)document.getIdentifier(), (Object)fromStorage.getIdentifier());
        Assert.assertEquals((Object)document.getName(), (Object)fromStorage.getName());
        Assert.assertEquals((long)content.length, (long)fromStorage.getContent().length);
    }

    @Test
    public void testSaveAndDeleteDocument() {
        byte[] content = "another document content".getBytes();
        Document document = this.documentStorageService.buildDocument("mydoc", (long)content.length, new Date(), new HashMap());
        Assert.assertNotNull((Object)document.getIdentifier());
        this.documentStorageService.saveDocument(document, content);
        Document fromStorage = this.documentStorageService.getDocument(document.getIdentifier());
        Assert.assertNotNull((Object)fromStorage);
        Assert.assertEquals((Object)document.getIdentifier(), (Object)fromStorage.getIdentifier());
        Assert.assertEquals((Object)document.getName(), (Object)fromStorage.getName());
        Assert.assertEquals((long)content.length, (long)fromStorage.getContent().length);
        this.documentStorageService.deleteDocument(fromStorage);
        fromStorage = this.documentStorageService.getDocument(document.getIdentifier());
        Assert.assertNull((Object)fromStorage);
    }

    @Test
    public void testSaveAndDeleteByIdDocument() {
        byte[] content = "yet another document content".getBytes();
        Document document = this.documentStorageService.buildDocument("mydoc", (long)content.length, new Date(), new HashMap());
        Assert.assertNotNull((Object)document.getIdentifier());
        this.documentStorageService.saveDocument(document, content);
        Document fromStorage = this.documentStorageService.getDocument(document.getIdentifier());
        Assert.assertNotNull((Object)fromStorage);
        Assert.assertEquals((Object)document.getIdentifier(), (Object)fromStorage.getIdentifier());
        Assert.assertEquals((Object)document.getName(), (Object)fromStorage.getName());
        Assert.assertEquals((long)content.length, (long)fromStorage.getContent().length);
        this.documentStorageService.deleteDocument(fromStorage.getIdentifier());
        fromStorage = this.documentStorageService.getDocument(document.getIdentifier());
        Assert.assertNull((Object)fromStorage);
    }

    @Test
    public void testSaveAndListDocuments() {
        long lastModified = System.currentTimeMillis() - 10000L;
        for (int i = 0; i < 10; ++i) {
            byte[] content = (i + " another document content").getBytes();
            Document document = this.documentStorageService.buildDocument("mydoc" + i, (long)content.length, new Date(lastModified + (long)(i * 1000)), new HashMap());
            Assert.assertNotNull((Object)document.getIdentifier());
            this.documentStorageService.saveDocument(document, content);
        }
        List docs = this.documentStorageService.listDocuments(Integer.valueOf(0), Integer.valueOf(5));
        Assert.assertNotNull((Object)docs);
        Assert.assertEquals((long)5L, (long)docs.size());
        Assert.assertEquals((Object)"mydoc0", (Object)((Document)docs.get(0)).getName());
        Assert.assertEquals((Object)"mydoc1", (Object)((Document)docs.get(1)).getName());
        Assert.assertEquals((Object)"mydoc2", (Object)((Document)docs.get(2)).getName());
        Assert.assertEquals((Object)"mydoc3", (Object)((Document)docs.get(3)).getName());
        Assert.assertEquals((Object)"mydoc4", (Object)((Document)docs.get(4)).getName());
        docs = this.documentStorageService.listDocuments(Integer.valueOf(1), Integer.valueOf(5));
        Assert.assertNotNull((Object)docs);
        Assert.assertEquals((long)5L, (long)docs.size());
        Assert.assertEquals((Object)"mydoc5", (Object)((Document)docs.get(0)).getName());
        Assert.assertEquals((Object)"mydoc6", (Object)((Document)docs.get(1)).getName());
        Assert.assertEquals((Object)"mydoc7", (Object)((Document)docs.get(2)).getName());
        Assert.assertEquals((Object)"mydoc8", (Object)((Document)docs.get(3)).getName());
        Assert.assertEquals((Object)"mydoc9", (Object)((Document)docs.get(4)).getName());
        docs = this.documentStorageService.listDocuments(Integer.valueOf(1), Integer.valueOf(2));
        Assert.assertNotNull((Object)docs);
        Assert.assertEquals((long)2L, (long)docs.size());
        Assert.assertEquals((Object)"mydoc2", (Object)((Document)docs.get(0)).getName());
        Assert.assertEquals((Object)"mydoc3", (Object)((Document)docs.get(1)).getName());
    }

    @Test
    public void testListDocumentsLessThanPageSize() {
        byte[] content = "yet another document content".getBytes();
        Document document = this.documentStorageService.buildDocument("mydoc", (long)content.length, new Date(), new HashMap());
        Assert.assertNotNull((Object)document.getIdentifier());
        this.documentStorageService.saveDocument(document, content);
        List docs = this.documentStorageService.listDocuments(Integer.valueOf(0), Integer.valueOf(5));
        Assert.assertNotNull((Object)docs);
        Assert.assertEquals((long)1L, (long)docs.size());
        Assert.assertEquals((Object)"mydoc", (Object)((Document)docs.get(0)).getName());
    }

    @Test
    public void testListDocumentsNonexistentDocsFolder() {
        File docsDir = new File(STORAGE_PATH_TEST);
        this.deleteFolder(docsDir);
        docsDir.delete();
        List docs = this.documentStorageService.listDocuments(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertTrue((String)"When documents directory doesn't exist, empty doc list should be returned", (boolean)docs.isEmpty());
    }
}

