/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.audit;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jbpm.document.Document;
import org.jbpm.document.DocumentCollection;
import org.jbpm.process.audit.VariableInstanceLog;
import org.kie.internal.process.ProcessVariableIndexer;

public class DocumentCollectionVariableIndexer
implements ProcessVariableIndexer {
    private static final String PATTERN = "{0} ({1}/{2})";

    public boolean accept(Object variable) {
        return variable instanceof DocumentCollection;
    }

    public List<org.kie.api.runtime.manager.audit.VariableInstanceLog> index(String name, Object variable) {
        DocumentCollection documentCollection = (DocumentCollection)variable;
        int max = documentCollection.getDocuments().size();
        return IntStream.range(0, max).mapToObj(index -> this.toVariableLog(name, index, max, (Document)documentCollection.getDocuments().get(index))).collect(Collectors.toList());
    }

    private org.kie.api.runtime.manager.audit.VariableInstanceLog toVariableLog(String name, int index, int max, Document document) {
        VariableInstanceLog processVariable = new VariableInstanceLog();
        processVariable.setVariableId(MessageFormat.format(PATTERN, name, index + 1, max));
        processVariable.setValue(document.toString());
        return processVariable;
    }
}

