/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.service.impl.util;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.document.service.impl.util.DocumentDownloadLinkGenerator;
import org.junit.Test;

public class DocumentDownloadLinkGeneratorTest {
    private static final String TEMPLATE_ID = "myTemplateId";
    private static final String DOC_ID = "myDocId";

    @Test
    public void testLinkGenerationFailure() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DocumentDownloadLinkGenerator.generateDownloadLink(null, (String)DOC_ID)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("ServerTemplateId cannot be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DocumentDownloadLinkGenerator.generateDownloadLink((String)TEMPLATE_ID, null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("DocumentIdentifier cannot be null");
    }

    @Test
    public void testLinkGeneration() {
        Assertions.assertThat((String)DocumentDownloadLinkGenerator.generateDownloadLink((String)TEMPLATE_ID, (String)DOC_ID)).doesNotContain((CharSequence)"{serverTemplateId}").doesNotContain((CharSequence)"{documentIdentifier}").contains(new CharSequence[]{TEMPLATE_ID}).contains(new CharSequence[]{DOC_ID});
    }
}

