/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.marshalling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jbpm.document.marshalling.DocumentCollectionImplMarshallingStrategy;
import org.jbpm.document.marshalling.DocumentMarshallingStrategy;
import org.jbpm.document.service.DocumentStorageService;
import org.jbpm.document.service.impl.DocumentCollectionImpl;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.document.service.impl.DocumentStorageServiceImpl;
import org.junit.Assert;
import org.junit.Test;

public class DocumentCollectionImplMarshallingStrategyTest {
    private static final String STORAGE_PATH_TEST = "target/docs";
    private DocumentCollectionImplMarshallingStrategy docsMarshallingStrategy = new DocumentCollectionImplMarshallingStrategy(this.createSingleDocMarshallingStrategy());

    @Test
    public void testMarshallUnmarshall() throws IOException, ClassNotFoundException {
        List<DocumentImpl> documents = this.getDocuments();
        DocumentCollectionImpl docs = new DocumentCollectionImpl(documents);
        byte[] marshalledDocs = this.docsMarshallingStrategy.marshal(null, null, (Object)docs);
        DocumentCollectionImpl unmarshalledDocs = (DocumentCollectionImpl)this.docsMarshallingStrategy.unmarshal(null, null, marshalledDocs, this.getClass().getClassLoader());
        Assert.assertEquals((long)docs.getDocuments().size(), (long)unmarshalledDocs.getDocuments().size());
        List unmarshalledDocumentsList = unmarshalledDocs.getDocuments();
        Assert.assertEquals((long)documents.size(), (long)unmarshalledDocumentsList.size());
        Assert.assertEquals((Object)((DocumentImpl)unmarshalledDocumentsList.get(0)).getName(), (Object)((DocumentImpl)docs.getDocuments().get(0)).getName());
        Assert.assertEquals((Object)((DocumentImpl)unmarshalledDocumentsList.get(0)).getLink(), (Object)((DocumentImpl)docs.getDocuments().get(0)).getLink());
        Assert.assertEquals((Object)((DocumentImpl)unmarshalledDocumentsList.get(1)).getName(), (Object)((DocumentImpl)docs.getDocuments().get(1)).getName());
        Assert.assertEquals((Object)((DocumentImpl)unmarshalledDocumentsList.get(1)).getLink(), (Object)((DocumentImpl)docs.getDocuments().get(1)).getLink());
    }

    private DocumentImpl getDocument(String documentName) {
        DocumentImpl documentOne = new DocumentImpl();
        documentOne.setIdentifier(documentName);
        documentOne.setLastModified(new Date());
        documentOne.setLink("http://" + documentName);
        documentOne.setName(documentName + " Name");
        documentOne.setSize(1L);
        documentOne.setContent(documentName.getBytes());
        return documentOne;
    }

    private List<DocumentImpl> getDocuments() {
        ArrayList<DocumentImpl> documents = new ArrayList<DocumentImpl>();
        documents.add(this.getDocument("documentOne"));
        documents.add(this.getDocument("documentTwo"));
        return documents;
    }

    private DocumentMarshallingStrategy createSingleDocMarshallingStrategy() {
        return new DocumentMarshallingStrategy((DocumentStorageService)new DocumentStorageServiceImpl(STORAGE_PATH_TEST));
    }
}

