/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.event.emitters.elasticsearch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.assertj.core.api.Assertions;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.event.emitters.elasticsearch.ElasticSearchEventEmitter;
import org.jbpm.event.emitters.elasticsearch.FakeElasticSearchRESTApplication;
import org.jbpm.event.emitters.elasticsearch.NotifyingThreadPoolExecutor;
import org.jbpm.persistence.api.integration.model.CaseInstanceView;
import org.jbpm.persistence.api.integration.model.ProcessInstanceView;
import org.jbpm.persistence.api.integration.model.TaskInstanceView;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.api.runtime.process.CaseData;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTaskData;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;

public class ElasticSearchEventEmitterTest {
    private static String dateFormatStr;
    private static Server server;
    private static List<String> responseCollector;

    @BeforeClass
    public static void initialize() throws Exception {
        dateFormatStr = "yyyy-MM-dd";
        System.setProperty("org.jbpm.event.emitters.elasticsearch.date_format", dateFormatStr);
        FakeElasticSearchRESTApplication application = new FakeElasticSearchRESTApplication(responseCollector);
        RuntimeDelegate delegate = RuntimeDelegate.getInstance();
        JAXRSServerFactoryBean bean = (JAXRSServerFactoryBean)delegate.createEndpoint((Application)application, JAXRSServerFactoryBean.class);
        String url = "http://localhost:9998" + bean.getAddress();
        bean.setAddress(url);
        server = bean.create();
        server.start();
        System.setProperty("org.jbpm.event.emitters.elasticsearch.url", url);
    }

    @AfterClass
    public static void destroy() throws Exception {
        if (server != null) {
            server.stop();
            server.destroy();
        }
        System.clearProperty("org.jbpm.event.emitters.elasticsearch.url");
    }

    @Before
    public void setup() {
        responseCollector.clear();
    }

    @Test
    public void testProcessInstanceThroughEmitter() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormatStr);
        Date sampleDate = sdf.parse("2018-10-23");
        String expectedResult = this.read(this.getClass().getResourceAsStream("/testProcessInstanceThroughEmitter.json"));
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)Mockito.mock(WorkflowProcessInstanceImpl.class);
        WorkflowProcessImpl process = (WorkflowProcessImpl)Mockito.mock(WorkflowProcessImpl.class);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("initiator", "john");
        variables.put("variable", 123);
        Mockito.when((Object)process.isDynamic()).thenReturn((Object)false);
        Mockito.when((Object)process.getVersion()).thenReturn((Object)"1.0");
        Mockito.when((Object)processInstance.getProcess()).thenReturn((Object)process);
        Mockito.when((Object)processInstance.getId()).thenReturn((Object)99L);
        Mockito.when((Object)processInstance.getDeploymentId()).thenReturn((Object)"test");
        Mockito.when((Object)processInstance.getCorrelationKey()).thenReturn((Object)"key");
        Mockito.when((Object)processInstance.getParentProcessInstanceId()).thenReturn((Object)-1L);
        Mockito.when((Object)processInstance.getProcessId()).thenReturn((Object)"myprocess");
        Mockito.when((Object)processInstance.getDescription()).thenReturn((Object)"");
        Mockito.when((Object)processInstance.getProcessName()).thenReturn((Object)"MyProcess");
        Mockito.when((Object)processInstance.getState()).thenReturn((Object)1);
        Mockito.when((Object)processInstance.getVariables()).thenReturn(variables);
        ArrayList<ProcessInstanceView> views = new ArrayList<ProcessInstanceView>();
        ProcessInstanceView instanceView = new ProcessInstanceView((ProcessInstance)processInstance);
        instanceView.copyFromSource();
        instanceView.setDate(sampleDate);
        views.add(instanceView);
        final CountDownLatch latch = new CountDownLatch(1);
        ElasticSearchEventEmitter emitter = new ElasticSearchEventEmitter(){

            protected ExecutorService buildExecutorService() {
                return ElasticSearchEventEmitterTest.this.createExecutor(latch);
            }
        };
        emitter.apply(views);
        latch.await(5L, TimeUnit.SECONDS);
        emitter.close();
        Assertions.assertThat(responseCollector).hasSize(1);
        Assertions.assertThat((String)responseCollector.get(0)).isEqualTo((Object)expectedResult);
    }

    @Test
    public void testCaseInstanceThroughEmitter() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormatStr);
        Date sampleDate = sdf.parse("2018-10-23");
        String expectedResult = this.read(this.getClass().getResourceAsStream("/testCaseInstanceThroughEmitter.json"));
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)Mockito.mock(WorkflowProcessInstanceImpl.class);
        WorkflowProcessImpl process = (WorkflowProcessImpl)Mockito.mock(WorkflowProcessImpl.class);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("initiator", "john");
        variables.put("variable", 123);
        Mockito.when((Object)process.isDynamic()).thenReturn((Object)false);
        Mockito.when((Object)process.getVersion()).thenReturn((Object)"1.0");
        CaseData caseData = (CaseData)Mockito.mock(CaseData.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{CaseAssignment.class}));
        HashMap<String, Object> caseVariables = new HashMap<String, Object>();
        caseVariables.put("caseDetail", "my test case");
        caseVariables.put("age", 55);
        Mockito.when((Object)caseData.getData()).thenReturn(caseVariables);
        ArrayList<CaseData> objects = new ArrayList<CaseData>();
        objects.add(caseData);
        InternalKnowledgeRuntime kruntime = (InternalKnowledgeRuntime)Mockito.mock(InternalKnowledgeRuntime.class);
        Mockito.when((Object)kruntime.getObjects((ObjectFilter)Matchers.any())).thenReturn(objects);
        Mockito.when((Object)processInstance.getProcess()).thenReturn((Object)process);
        Mockito.when((Object)processInstance.getId()).thenReturn((Object)99L);
        Mockito.when((Object)processInstance.getDeploymentId()).thenReturn((Object)"test");
        Mockito.when((Object)processInstance.getCorrelationKey()).thenReturn((Object)"key");
        Mockito.when((Object)processInstance.getParentProcessInstanceId()).thenReturn((Object)-1L);
        Mockito.when((Object)processInstance.getProcessId()).thenReturn((Object)"myprocess");
        Mockito.when((Object)processInstance.getDescription()).thenReturn((Object)"");
        Mockito.when((Object)processInstance.getProcessName()).thenReturn((Object)"MyProcess");
        Mockito.when((Object)processInstance.getState()).thenReturn((Object)1);
        Mockito.when((Object)processInstance.getVariables()).thenReturn(variables);
        Mockito.when((Object)processInstance.getKnowledgeRuntime()).thenReturn((Object)kruntime);
        ArrayList<CaseInstanceView> views = new ArrayList<CaseInstanceView>();
        CaseInstanceView instanceView = new CaseInstanceView((ProcessInstance)processInstance);
        instanceView.copyFromSource();
        instanceView.setDate(sampleDate);
        views.add(instanceView);
        final CountDownLatch latch = new CountDownLatch(1);
        ElasticSearchEventEmitter emitter = new ElasticSearchEventEmitter(){

            protected ExecutorService buildExecutorService() {
                return ElasticSearchEventEmitterTest.this.createExecutor(latch);
            }
        };
        emitter.apply(views);
        latch.await(5L, TimeUnit.SECONDS);
        emitter.close();
        Assertions.assertThat(responseCollector).hasSize(1);
        Assertions.assertThat((String)responseCollector.get(0)).isEqualTo((Object)expectedResult);
    }

    @Test
    public void testTaskInstanceThroughEmitter() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormatStr);
        Date sampleDate = sdf.parse("2018-10-23");
        String expectedResult = this.read(this.getClass().getResourceAsStream("/testTaskInstanceThroughEmitter.json"));
        Task taskInstance = (Task)Mockito.mock(Task.class);
        InternalTaskData taskData = (InternalTaskData)Mockito.mock(InternalTaskData.class);
        User user = (User)Mockito.mock(User.class);
        InternalPeopleAssignments peopleAssignments = (InternalPeopleAssignments)Mockito.mock(InternalPeopleAssignments.class);
        Mockito.when((Object)peopleAssignments.getBusinessAdministrators()).thenReturn(Collections.emptyList());
        Mockito.when((Object)peopleAssignments.getExcludedOwners()).thenReturn(Collections.emptyList());
        Mockito.when((Object)peopleAssignments.getPotentialOwners()).thenReturn(Collections.emptyList());
        Mockito.when((Object)user.getId()).thenReturn((Object)"john");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("initiator", "john");
        variables.put("variable", 123);
        HashMap<String, Object> outputVariables = new HashMap<String, Object>();
        outputVariables.put("outcome", "good work");
        outputVariables.put("score", 55);
        Mockito.when((Object)taskData.getActivationTime()).thenReturn((Object)sampleDate);
        Mockito.when((Object)taskData.getActualOwner()).thenReturn((Object)user);
        Mockito.when((Object)taskData.getDeploymentId()).thenReturn((Object)"test");
        Mockito.when((Object)taskData.getCreatedBy()).thenReturn((Object)user);
        Mockito.when((Object)taskData.getCreatedOn()).thenReturn((Object)sampleDate);
        Mockito.when((Object)taskData.getExpirationTime()).thenReturn((Object)sampleDate);
        Mockito.when((Object)taskData.getTaskInputVariables()).thenReturn(variables);
        Mockito.when((Object)taskData.getTaskOutputVariables()).thenReturn(outputVariables);
        Mockito.when((Object)taskData.getParentId()).thenReturn((Object)-1L);
        Mockito.when((Object)taskData.getProcessId()).thenReturn((Object)"process");
        Mockito.when((Object)taskData.getProcessInstanceId()).thenReturn((Object)99L);
        Mockito.when((Object)taskData.isSkipable()).thenReturn((Object)true);
        Mockito.when((Object)taskData.getStatus()).thenReturn((Object)Status.Reserved);
        Mockito.when((Object)taskData.getWorkItemId()).thenReturn((Object)100L);
        Mockito.when((Object)taskInstance.getId()).thenReturn((Object)44L);
        Mockito.when((Object)taskInstance.getPeopleAssignments()).thenReturn((Object)peopleAssignments);
        Mockito.when((Object)taskInstance.getDescription()).thenReturn((Object)"simple task");
        Mockito.when((Object)taskInstance.getFormName()).thenReturn((Object)"simpletask");
        Mockito.when((Object)taskInstance.getName()).thenReturn((Object)"Simple Task");
        Mockito.when((Object)taskInstance.getSubject()).thenReturn((Object)"empty");
        Mockito.when((Object)taskInstance.getPriority()).thenReturn((Object)5);
        Mockito.when((Object)taskInstance.getTaskType()).thenReturn((Object)"");
        Mockito.when((Object)taskInstance.getTaskData()).thenReturn((Object)taskData);
        ArrayList<TaskInstanceView> views = new ArrayList<TaskInstanceView>();
        TaskInstanceView instanceView = new TaskInstanceView(taskInstance);
        instanceView.copyFromSource();
        views.add(instanceView);
        final CountDownLatch latch = new CountDownLatch(1);
        ElasticSearchEventEmitter emitter = new ElasticSearchEventEmitter(){

            protected ExecutorService buildExecutorService() {
                return ElasticSearchEventEmitterTest.this.createExecutor(latch);
            }
        };
        emitter.apply(views);
        latch.await(5L, TimeUnit.SECONDS);
        emitter.close();
        Assertions.assertThat(responseCollector).hasSize(1);
        Assertions.assertThat((String)responseCollector.get(0)).isEqualTo((Object)expectedResult);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String read(InputStream input) {
        String lineSeparator = System.getProperty("line.separator");
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, Charset.forName("UTF-8")));){
            String string = buffer.lines().collect(Collectors.joining(lineSeparator)) + lineSeparator;
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected NotifyingThreadPoolExecutor createExecutor(CountDownLatch latch) {
        NotifyingThreadPoolExecutor executor = new NotifyingThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        executor.setLatch(latch);
        return executor;
    }

    static {
        responseCollector = new ArrayList<String>();
    }
}

