/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.event.emitters.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jbpm.persistence.api.integration.EventCollection;
import org.jbpm.persistence.api.integration.EventEmitter;
import org.jbpm.persistence.api.integration.InstanceView;
import org.jbpm.persistence.api.integration.base.BaseEventCollection;
import org.jbpm.persistence.api.integration.model.CaseInstanceView;
import org.jbpm.persistence.api.integration.model.ProcessInstanceView;
import org.jbpm.persistence.api.integration.model.TaskInstanceView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchEventEmitter
implements EventEmitter {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchEventEmitter.class);
    private String dateFormatStr = System.getProperty("org.jbpm.event.emitters.elasticsearch.date_format", System.getProperty("org.kie.server.json.date_format", "yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
    private String elasticSearchUrl = System.getProperty("org.jbpm.event.emitters.elasticsearch.url", "http://localhost:9200");
    private String elasticSearchUser = System.getProperty("org.jbpm.event.emitters.elasticsearch.user");
    private String elasticSearchPassword = System.getProperty("org.jbpm.event.emitters.elasticsearch.password");
    private ObjectMapper mapper = new ObjectMapper();
    private ExecutorService executor;
    private CloseableHttpClient httpclient;

    public ElasticSearchEventEmitter() {
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat(this.dateFormatStr));
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        this.executor = this.buildExecutorService();
        this.httpclient = this.buildClient();
    }

    public void deliver(Collection<InstanceView<?>> data) {
    }

    public void apply(Collection<InstanceView<?>> data) {
        if (data.isEmpty()) {
            return;
        }
        this.executor.execute(() -> {
            StringBuilder content = new StringBuilder();
            for (InstanceView view : data) {
                try {
                    String json = this.mapper.writeValueAsString((Object)view);
                    String index = "jbpm";
                    String type = "unknown";
                    String id = "";
                    if (view instanceof ProcessInstanceView) {
                        index = "processes";
                        type = "process";
                        id = ((ProcessInstanceView)view).getCompositeId();
                    } else if (view instanceof TaskInstanceView) {
                        index = "tasks";
                        type = "task";
                        id = ((TaskInstanceView)view).getCompositeId();
                    } else if (view instanceof CaseInstanceView) {
                        index = "cases";
                        type = "case";
                        id = ((CaseInstanceView)view).getCompositeId();
                    }
                    content.append("{ \"index\" : { \"_index\" : \"" + index + "\", \"_type\" : \"" + type + "\", \"_id\" : \"" + id + "\" } }\n");
                    content.append(json);
                    content.append("\n");
                }
                catch (JsonProcessingException e) {
                    logger.error("Error while serializing {} to JSON", (Object)view, (Object)e);
                }
            }
            try {
                HttpPut httpPut = new HttpPut(this.elasticSearchUrl + "/_bulk");
                httpPut.setEntity((HttpEntity)new StringEntity(content.toString(), "UTF-8"));
                logger.debug("Executing request " + httpPut.getRequestLine());
                httpPut.setHeader("Content-Type", "application/x-ndjson");
                ResponseHandler responseHandler = response -> {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                };
                String responseBody = (String)this.httpclient.execute((HttpUriRequest)httpPut, responseHandler);
                logger.debug("Elastic search response '{}'", (Object)responseBody);
            }
            catch (Exception e) {
                logger.error("Unexpected exception while sending data to ElasticSearch", (Throwable)e);
            }
        });
    }

    public void drop(Collection<InstanceView<?>> data) {
    }

    public EventCollection newCollection() {
        return new BaseEventCollection();
    }

    public void close() {
        try {
            this.httpclient.close();
        }
        catch (IOException e) {
            logger.error("Error when closing http client", (Throwable)e);
        }
        this.executor.shutdown();
        logger.info("Elasticsearch event emitter closed successfully");
    }

    protected CloseableHttpClient buildClient() {
        HttpClientBuilder builder = HttpClients.custom();
        if (this.elasticSearchUser != null && this.elasticSearchPassword != null) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.elasticSearchUser, this.elasticSearchPassword);
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        return builder.build();
    }

    protected ExecutorService buildExecutorService() {
        return Executors.newCachedThreadPool();
    }
}

